/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class DbgLogger {
    private static Logger impl = Logger.getLogger("robovm-debugger");
    private final String tag;

    private DbgLogger(String tag) {
        this.tag = tag + ": ";
    }

    public void debug(String message) {
        impl.log(Level.INFO, this.tag + message);
    }

    public void info(String message) {
        impl.log(Level.INFO, this.tag + message);
    }

    public void warn(String message) {
        impl.log(Level.WARNING, this.tag + message);
    }

    public void error(String message) {
        impl.log(Level.SEVERE, this.tag + message);
    }

    public void error(String message, Throwable e) {
        impl.log(Level.SEVERE, this.tag + message, e);
    }

    public static DbgLogger get(String tag) {
        return new DbgLogger(tag);
    }

    public static void setup(File logFile, boolean enableConsole) {
        StreamHandler handler;
        for (Handler h : impl.getHandlers()) {
            impl.removeHandler(h);
        }
        if (logFile != null) {
            try {
                handler = new FileHandler(logFile.getAbsolutePath());
                handler.setFormatter(new DbgFormatter());
                impl.addHandler(handler);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (enableConsole) {
            handler = new ConsoleHandler();
            handler.setFormatter(new DbgFormatter());
            impl.addHandler(handler);
        }
    }

    static {
        impl.setLevel(Level.ALL);
        impl.setUseParentHandlers(false);
    }

    private static class DbgFormatter
    extends Formatter {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        private final Date date = new Date();
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");

        private DbgFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            this.date.setTime(record.getMillis());
            sb.append(this.dateFormat.format(this.date)).append(" ").append(record.getLevel().getLocalizedName()).append(": ").append(this.formatMessage(record)).append(LINE_SEPARATOR);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return sb.toString();
        }
    }
}

