/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.util.Iterator;
import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;

public class ByteBufferArrayReader<T>
implements Iterable<T> {
    private final ByteBufferReader bufferReader;
    private final int elementSize;
    private final ObjectReader<T> objectReader;
    private final int size;
    private final boolean reuseElement;
    private T lastAccessedObject;

    public ByteBufferArrayReader(ByteBufferReader bufferReader, int elementSize, ObjectReader<T> objectReader, boolean reuseElement) {
        this.bufferReader = bufferReader;
        this.elementSize = elementSize;
        this.objectReader = objectReader;
        this.size = bufferReader.size() / elementSize;
        this.reuseElement = reuseElement;
    }

    public ByteBufferArrayReader(ByteBufferReader bufferReader, int elementSize, ObjectReader<T> objectReader) {
        this(bufferReader, elementSize, objectReader, true);
    }

    public T get(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException();
        }
        this.bufferReader.setPosition(this.elementSize * index);
        this.lastAccessedObject = this.objectReader.readObject(this.bufferReader, this.reuseElement ? (Object)this.lastAccessedObject : null);
        if (this.bufferReader.position() - this.elementSize * index != this.elementSize) {
            throw new IllegalStateException("Object size specified doesn't match actual read from reader");
        }
        return this.lastAccessedObject;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < ByteBufferArrayReader.this.size;
            }

            @Override
            public T next() {
                return ByteBufferArrayReader.this.get(this.idx++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static interface ObjectReader<T> {
        public T readObject(ByteBufferReader var1, T var2);
    }
}

