/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.macho;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robovm.debugger.utils.bytebuffer.ByteBufferArrayReader;
import org.robovm.debugger.utils.bytebuffer.ByteBufferMemoryReader;
import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;
import org.robovm.debugger.utils.macho.MachOException;
import org.robovm.debugger.utils.macho.cmds.SegmentCommand;
import org.robovm.debugger.utils.macho.cmds.SymtabCommand;
import org.robovm.debugger.utils.macho.structs.MachHeader;
import org.robovm.debugger.utils.macho.structs.NList;
import org.robovm.debugger.utils.macho.structs.Section;

public class MachOLoader {
    private final ByteBufferReader rootReader;
    private final MachHeader machOHeader;
    private final int machOCpuType;
    private List<SegmentCommand> segments = new ArrayList<SegmentCommand>();
    private Map<String, Long> symTable = new HashMap<String, Long>();
    private SegmentCommand dataSegment;

    public MachOLoader(File executable, int cpuType) throws MachOException {
        ByteBuffer bb;
        try {
            bb = new RandomAccessFile(executable, "r").getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, executable.length()).asReadOnlyBuffer();
        }
        catch (IOException e) {
            throw new MachOException("Failed to open mach-o file", e);
        }
        this.rootReader = ByteBufferReader.wrap(bb);
        this.rootReader.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long magic = this.rootReader.readUnsignedInt32();
        if (magic == 3199925962L || magic == 3216703178L) {
            throw new MachOException("FAT mach-o files are not supported!");
        }
        MachHeader header = this.parseMachHeader(this.rootReader, magic);
        if (header.cputype() != cpuType) {
            throw new MachOException("CPU type " + Integer.toHexString(cpuType) + " is not present in mach-o file");
        }
        this.machOHeader = header;
        this.machOCpuType = cpuType;
        this.readCommandData(this.rootReader, this.machOHeader);
    }

    private MachHeader parseMachHeader(ByteBufferReader reader, long magic) throws MachOException {
        if (magic != 4277009102L && magic != 4277009103L) {
            throw new MachOException("unexpected Mach header MAGIC 0x" + Long.toHexString(magic));
        }
        return new MachHeader(reader, magic == 4277009103L);
    }

    private void readCommandData(ByteBufferReader reader, MachHeader header) {
        int sectionIdx = 1;
        int idx = 0;
        while ((long)idx < header.ncmds()) {
            int pos = reader.position();
            int cmd = (int)reader.readUnsignedInt32();
            int cmdsize = (int)reader.readUnsignedInt32();
            if (cmd == 1 || cmd == 25) {
                SegmentCommand segCmd = new SegmentCommand(reader, cmd == 25, sectionIdx);
                if (header.is64b() != segCmd.is64b()) {
                    throw new RuntimeException("bits of LC_SEGMENT shall match MAGIC header");
                }
                this.segments.add(segCmd);
                sectionIdx += segCmd.sections().length;
                if ("__DATA".equals(segCmd.segname())) {
                    this.dataSegment = segCmd;
                }
            } else if (cmd == 2) {
                SymtabCommand symtabCommand = new SymtabCommand(reader);
                ByteBufferReader stringReader = reader.sliceAt((int)symtabCommand.stroff, (int)symtabCommand.strsize);
                ByteBufferReader nlistReader = reader.sliceAt((int)symtabCommand.symoff, (int)(symtabCommand.nsyms * (long)NList.ITEM_SIZE(header.is64b())));
                ByteBufferArrayReader<NList> arrayReader = new ByteBufferArrayReader<NList>(nlistReader, NList.ITEM_SIZE(header.is64b()), NList.OBJECT_READER(header.is64b()));
                for (NList nlist2 : arrayReader) {
                    if (!nlist2.isTypeStab() ? nlist2.isTypeUndfined() || nlist2.isTypePreboundUndefined() : !nlist2.isTypeStabGlobalSymb()) continue;
                    if (nlist2.n_sect() == 0) continue;
                    String sym = stringReader.readStringZ((int)nlist2.n_strx());
                    this.symTable.put(sym, nlist2.getByteBufferOffset());
                }
            }
            reader.setPosition(pos + cmdsize);
            ++idx;
        }
    }

    public static int cpuTypeFromString(String cpuString) {
        switch (cpuString) {
            case "i386": 
            case "x86": {
                return 7;
            }
            case "x86_64": {
                return 0x1000007;
            }
            case "thumbv7": 
            case "armv7": {
                return 12;
            }
            case "arm64": {
                return 0x100000C;
            }
        }
        return -1;
    }

    public int cpuType() {
        return this.machOCpuType;
    }

    public boolean isPatform64Bit() {
        switch (this.machOCpuType) {
            case 0x1000007: 
            case 0x100000C: {
                return true;
            }
            case 7: 
            case 12: {
                return false;
            }
        }
        throw new RuntimeException("Unknown CPU type to get data bit width " + this.machOCpuType);
    }

    public long resolveSymbol(String symbolName) {
        Long nlistAddr = this.symTable.get("_" + symbolName);
        if (nlistAddr == null) {
            return -1L;
        }
        this.rootReader.setPosition(nlistAddr);
        NList nlist2 = NList.OBJECT_READER(this.machOHeader.is64b()).readObject(this.rootReader, null);
        return nlist2.n_value();
    }

    public ByteBufferMemoryReader memoryReader() {
        ArrayList<ByteBufferMemoryReader.MemoryRegion> regions = new ArrayList<ByteBufferMemoryReader.MemoryRegion>();
        for (SegmentCommand segCmd : this.segments) {
            boolean isText = "__TEXT".equals(segCmd.segname());
            boolean isData = "__DATA".equals(segCmd.segname());
            if (!isText && !isData) continue;
            for (Section sec : segCmd.sections()) {
                if (isText ? !"__const".equals(sec.sectname()) && !"__text".equals(sec.sectname()) : !isData || !"__const".equals(sec.sectname()) && !"__data".equals(sec.sectname())) continue;
                regions.add(new ByteBufferMemoryReader.MemoryRegion(sec.addr(), sec.addr() + sec.size() - 1L, (int)sec.offset()));
            }
        }
        if (this.dataSegment == null) {
            return null;
        }
        return new ByteBufferMemoryReader(this.rootReader, 0, this.rootReader.size(), this.isPatform64Bit(), regions.toArray(new ByteBufferMemoryReader.MemoryRegion[regions.size()]));
    }

    public static void main(String[] argv) {
        try {
            MachOLoader loader = new MachOLoader(new File(argv[0]), MachOLoader.cpuTypeFromString(argv[1]));
            System.out.println("Segments:");
            System.out.println(String.format("  %-30s | %10s | %16s | %16s", "", "size", "file_offs", "vm_addr"));
            for (SegmentCommand segmentCommand : loader.segments) {
                System.out.println(String.format("  %-30s | %10X | %16X | %16X", segmentCommand.segname(), segmentCommand.filesize(), segmentCommand.fileoff(), segmentCommand.vmaddr()));
                int idx = 0;
                for (Section section : segmentCommand.sections()) {
                    System.out.println(String.format("  %4d:%-25s | %10X | %16X | %16X", segmentCommand.firstSectionIdx() + idx, section.sectname(), section.size(), section.offset(), section.addr()));
                    ++idx;
                }
            }
            System.out.println(String.format("Symbols(%d):", loader.symTable.size()));
            for (Map.Entry entry : loader.symTable.entrySet()) {
                System.out.println("  " + (String)entry.getKey());
            }
        }
        catch (MachOException e) {
            e.printStackTrace();
        }
    }
}

