/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.macho.structs;

import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;

public class MachHeader {
    private int cputype;
    private int cpusubtype;
    private long filetype;
    private long ncmds;
    private long sizeofcmds;
    private long flags;
    private long reserved;
    private boolean is64b;

    public MachHeader(ByteBufferReader reader, boolean is64b) {
        if (is64b) {
            this.read64(reader);
        } else {
            this.read32(reader);
        }
    }

    public MachHeader read32(ByteBufferReader reader) {
        this.is64b = false;
        this.cputype = reader.readInt32();
        this.cpusubtype = reader.readInt32();
        this.filetype = reader.readInt32();
        this.ncmds = reader.readInt32();
        this.sizeofcmds = reader.readInt32();
        this.flags = reader.readInt32();
        return this;
    }

    public MachHeader read64(ByteBufferReader reader) {
        this.is64b = true;
        this.cputype = reader.readInt32();
        this.cpusubtype = reader.readInt32();
        this.filetype = reader.readUnsignedInt32();
        this.ncmds = reader.readUnsignedInt32();
        this.sizeofcmds = reader.readUnsignedInt32();
        this.flags = reader.readUnsignedInt32();
        this.reserved = reader.readUnsignedInt32();
        return this;
    }

    public int cputype() {
        return this.cputype;
    }

    public int cpusubtype() {
        return this.cpusubtype;
    }

    public long filetype() {
        return this.filetype;
    }

    public long ncmds() {
        return this.ncmds;
    }

    public long sizeofcmds() {
        return this.sizeofcmds;
    }

    public long flags() {
        return this.flags;
    }

    public boolean is64b() {
        return this.is64b;
    }
}

