/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners;

import com.google.inject.Module;
import java.net.URL;
import javax.inject.Qualifier;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.guice.bean.scanners.ClassSpaceScanner;
import org.sonatype.guice.bean.scanners.ClassSpaceVisitor;
import org.sonatype.guice.bean.scanners.EmptyClassVisitor;
import org.sonatype.guice.bean.scanners.QualifiedTypeListener;
import org.sonatype.guice.bean.scanners.QualifierCache;
import org.sonatype.guice.bean.scanners.asm.AnnotationVisitor;
import org.sonatype.guice.bean.scanners.asm.ClassVisitor;

public final class QualifiedTypeVisitor
extends EmptyClassVisitor
implements ClassSpaceVisitor {
    private final QualifierCache qualifierCache = new QualifierCache();
    private final QualifiedTypeListener listener;
    private ClassSpace space;
    private URL location;
    private String source;
    private String clazzName;
    private boolean qualified;

    public QualifiedTypeVisitor(QualifiedTypeListener listener) {
        this.listener = listener;
    }

    public void visit(ClassSpace _space) {
        this.space = _space;
        this.source = null;
        if (Logs.DEBUG_ENABLED) {
            ClassSpaceScanner.verify(_space, Qualifier.class, Module.class);
        }
    }

    public ClassVisitor visitClass(URL url) {
        this.location = url;
        this.clazzName = null;
        this.qualified = false;
        return this;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x1600) == 0) {
            this.clazzName = name;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
        if (null != this.clazzName) {
            this.qualified = this.qualified || this.qualifierCache.qualify(this.space, desc2);
        }
        return null;
    }

    public void visitEnd() {
        if (this.qualified) {
            this.qualified = false;
            String path = this.location.getPath();
            if (null == this.source || !path.startsWith(this.source)) {
                int i = path.indexOf(this.clazzName);
                this.source = i <= 0 ? path : path.substring(0, i);
            }
            this.listener.hear(null, this.space.loadClass(this.clazzName.replace('/', '.')), this.source);
        }
    }
}

