/*
 * Decompiled with CFR 0.152.
 */
package com.mobidevelop.robovm.asm.util;

import com.mobidevelop.robovm.asm.AnnotationVisitor;
import com.mobidevelop.robovm.asm.Attribute;
import com.mobidevelop.robovm.asm.FieldVisitor;
import com.mobidevelop.robovm.asm.TypePath;
import com.mobidevelop.robovm.asm.util.CheckAnnotationAdapter;
import com.mobidevelop.robovm.asm.util.CheckClassAdapter;
import com.mobidevelop.robovm.asm.util.CheckMethodAdapter;

public class CheckFieldAdapter
extends FieldVisitor {
    private boolean end;

    public CheckFieldAdapter(FieldVisitor fv) {
        this(327680, fv);
        if (this.getClass() != CheckFieldAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckFieldAdapter(int api, FieldVisitor fv) {
        super(api, fv);
    }

    public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
        this.checkEnd();
        CheckMethodAdapter.checkDesc(desc2, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(desc2, visible));
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
        this.checkEnd();
        int sort = typeRef >>> 24;
        if (sort != 19) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(sort));
        }
        CheckClassAdapter.checkTypeRefAndPath(typeRef, typePath);
        CheckMethodAdapter.checkDesc(desc2, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(typeRef, typePath, desc2, visible));
    }

    public void visitAttribute(Attribute attr) {
        this.checkEnd();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attr);
    }

    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        super.visitEnd();
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

