/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http4;

import com.mobidevelop.robovm.org.apache.http.Header;
import com.mobidevelop.robovm.org.apache.http.HttpEntity;
import com.mobidevelop.robovm.org.apache.http.HttpException;
import com.mobidevelop.robovm.org.apache.http.HttpHost;
import com.mobidevelop.robovm.org.apache.http.HttpResponse;
import com.mobidevelop.robovm.org.apache.http.auth.AuthScope;
import com.mobidevelop.robovm.org.apache.http.auth.Credentials;
import com.mobidevelop.robovm.org.apache.http.auth.NTCredentials;
import com.mobidevelop.robovm.org.apache.http.auth.UsernamePasswordCredentials;
import com.mobidevelop.robovm.org.apache.http.client.methods.HttpGet;
import com.mobidevelop.robovm.org.apache.http.client.methods.HttpHead;
import com.mobidevelop.robovm.org.apache.http.client.methods.HttpPut;
import com.mobidevelop.robovm.org.apache.http.client.methods.HttpUriRequest;
import com.mobidevelop.robovm.org.apache.http.conn.ClientConnectionManager;
import com.mobidevelop.robovm.org.apache.http.conn.scheme.PlainSocketFactory;
import com.mobidevelop.robovm.org.apache.http.conn.scheme.Scheme;
import com.mobidevelop.robovm.org.apache.http.conn.scheme.SchemeRegistry;
import com.mobidevelop.robovm.org.apache.http.conn.ssl.SSLSocketFactory;
import com.mobidevelop.robovm.org.apache.http.conn.ssl.X509HostnameVerifier;
import com.mobidevelop.robovm.org.apache.http.entity.AbstractHttpEntity;
import com.mobidevelop.robovm.org.apache.http.impl.auth.BasicScheme;
import com.mobidevelop.robovm.org.apache.http.impl.client.BasicAuthCache;
import com.mobidevelop.robovm.org.apache.http.impl.client.DefaultHttpClient;
import com.mobidevelop.robovm.org.apache.http.impl.conn.BasicClientConnectionManager;
import com.mobidevelop.robovm.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.mobidevelop.robovm.org.apache.http.impl.cookie.DateParseException;
import com.mobidevelop.robovm.org.apache.http.impl.cookie.DateUtils;
import com.mobidevelop.robovm.org.apache.http.message.BasicHeader;
import com.mobidevelop.robovm.org.apache.http.params.HttpParams;
import com.mobidevelop.robovm.org.apache.http.protocol.BasicHttpContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.shared.http4.ConfigurableSSLSocketFactoryDecorator;
import org.apache.maven.wagon.shared.http4.HttpConfiguration;
import org.apache.maven.wagon.shared.http4.HttpMethodConfiguration;
import org.apache.maven.wagon.shared.http4.RelaxedX509TrustManager;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractHttpClientWagon
extends StreamWagon {
    private BasicHttpContext localContext;
    protected static final int SC_NULL = -1;
    protected static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private DefaultHttpClient client;
    protected static ClientConnectionManager connectionManagerPooled;
    protected ClientConnectionManager clientConnectionManager = new BasicClientConnectionManager(AbstractHttpClientWagon.createSchemeRegistry());
    protected static boolean useClientManagerPooled;
    protected static boolean sslInsecure;
    protected static boolean IGNORE_SSL_VALIDITY_DATES;
    protected static boolean sslAllowAll;
    private Properties httpHeaders;
    private HttpConfiguration httpConfiguration;
    private HttpGet getMethod;

    private static SchemeRegistry createSchemeRegistry() {
        SSLSocketFactory sslSocketFactory;
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, PlainSocketFactory.getSocketFactory()));
        if (sslInsecure) {
            try {
                sslSocketFactory = new SSLSocketFactory(RelaxedX509TrustManager.createRelaxedSSLContext(), sslAllowAll ? new RelaxedHostNameVerifier() : SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to init SSLSocket Factory " + e.getMessage(), e);
            }
        } else {
            sslSocketFactory = new SSLSocketFactory(HttpsURLConnection.getDefaultSSLSocketFactory(), SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        }
        Scheme httpsScheme = new Scheme("https", 443, new ConfigurableSSLSocketFactoryDecorator(sslSocketFactory));
        schemeRegistry.register(httpsScheme);
        return schemeRegistry;
    }

    public ClientConnectionManager getConnectionManager() {
        if (!useClientManagerPooled) {
            return this.clientConnectionManager;
        }
        return connectionManagerPooled;
    }

    public static void setConnectionManagerPooled(ClientConnectionManager clientConnectionManager) {
        connectionManagerPooled = clientConnectionManager;
    }

    public static void setUseClientManagerPooled(boolean pooledClientManager) {
        useClientManagerPooled = pooledClientManager;
    }

    public void openConnectionInternal() {
        ProxyInfo proxyInfo;
        this.repository.setUrl(this.getURL(this.repository));
        this.client = new DefaultHttpClient(this.getConnectionManager());
        this.client.getParams().setParameter("http.protocol.cookie-policy", "compatibility");
        if (this.authenticationInfo != null) {
            String username = this.authenticationInfo.getUserName();
            String password = this.authenticationInfo.getPassword();
            if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
                String host = this.getRepository().getHost();
                int port = this.getRepository().getPort() > -1 ? this.getRepository().getPort() : -1;
                this.client.getCredentialsProvider().setCredentials(new AuthScope(host, port), creds);
            }
        }
        if ((proxyInfo = this.getProxyInfo(this.getRepository().getProtocol(), this.getRepository().getHost())) != null) {
            String proxyUsername = proxyInfo.getUserName();
            String proxyPassword = proxyInfo.getPassword();
            String proxyHost = proxyInfo.getHost();
            int proxyPort = proxyInfo.getPort();
            String proxyNtlmHost = proxyInfo.getNtlmHost();
            String proxyNtlmDomain = proxyInfo.getNtlmDomain();
            if (proxyHost != null) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                if (proxyUsername != null && proxyPassword != null) {
                    Credentials creds = proxyNtlmHost != null || proxyNtlmDomain != null ? new NTCredentials(proxyUsername, proxyPassword, proxyNtlmHost, proxyNtlmDomain) : new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                    int port = proxyInfo.getPort() > -1 ? proxyInfo.getPort() : -1;
                    AuthScope authScope = new AuthScope(proxyHost, port);
                    this.client.getCredentialsProvider().setCredentials(authScope, creds);
                }
                this.client.getParams().setParameter("http.route.default-proxy", proxy);
            }
        }
    }

    public void closeConnection() {
        if (!useClientManagerPooled) {
            this.getConnectionManager().shutdown();
        }
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.put(null, resource, source);
    }

    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, null);
        resource.setContentLength(contentLength);
        resource.setLastModified(lastModified);
        this.put(stream, resource, null);
    }

    private void put(InputStream stream, Resource resource, File source) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.put(resource, source, new RequestEntityImplementation(stream, resource, this, source));
    }

    private void put(Resource resource, File source, HttpEntity httpEntity) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        String[] parts;
        StringBuilder url = new StringBuilder(this.getURL(this.getRepository()));
        for (String part : parts = StringUtils.split(resource.getName(), "/")) {
            if (!url.toString().endsWith("/")) {
                url.append('/');
            }
            url.append(URLEncoder.encode(part));
        }
        this.put(resource, source, httpEntity, url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Resource resource, File source, HttpEntity httpEntity, String url) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        try {
            this.mkdirs(PathUtils.dirname(resource.getName()));
        }
        catch (HttpException he) {
            this.fireTransferError(resource, he, 5);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
        }
        if (this.authenticationInfo != null) {
            String username = this.authenticationInfo.getUserName();
            String password = this.authenticationInfo.getPassword();
            if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                HttpHost targetHost = new HttpHost(this.repository.getHost(), this.repository.getPort(), this.repository.getProtocol());
                authCache.put(targetHost, basicAuth);
                this.localContext = new BasicHttpContext();
                this.localContext.setAttribute("http.auth.auth-cache", authCache);
            }
        }
        HttpPut putMethod = new HttpPut(url);
        this.firePutStarted(resource, source);
        try {
            HttpResponse response;
            putMethod.setEntity(httpEntity);
            try {
                response = this.execute(putMethod);
            }
            catch (IOException e) {
                this.fireTransferError(resource, e, 6);
                throw new TransferFailedException(e.getMessage(), e);
            }
            catch (HttpException e) {
                this.fireTransferError(resource, e, 6);
                throw new TransferFailedException(e.getMessage(), e);
            }
            int statusCode = response.getStatusLine().getStatusCode();
            String reasonPhrase = ", ReasonPhrase: " + response.getStatusLine().getReasonPhrase() + ".";
            this.fireTransferDebug(url + " - Status code: " + statusCode + reasonPhrase);
            switch (statusCode) {
                case 200: 
                case 201: 
                case 202: 
                case 204: {
                    break;
                }
                case 301: 
                case 302: 
                case 303: {
                    this.put(resource, source, httpEntity, this.calculateRelocatedUrl(response));
                    return;
                }
                case -1: {
                    TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + reasonPhrase);
                    this.fireTransferError(resource, e, 6);
                    throw e;
                }
                case 403: {
                    this.fireSessionConnectionRefused();
                    throw new AuthorizationException("Access denied to: " + url + reasonPhrase);
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + url + " does not exist" + reasonPhrase);
                }
                default: {
                    TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode + reasonPhrase);
                    this.fireTransferError(resource, e, 6);
                    throw e;
                }
            }
            this.firePutCompleted(resource, source);
        }
        finally {
            putMethod.abort();
        }
    }

    protected String calculateRelocatedUrl(HttpResponse response) {
        Header locationHeader = response.getFirstHeader("Location");
        String locationField = locationHeader.getValue();
        return locationField.startsWith("http") ? locationField : this.getURL(this.getRepository()) + '/' + locationField;
    }

    protected void mkdirs(String dirname) throws HttpException, IOException {
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        String repositoryUrl = this.getRepository().getUrl();
        String url = repositoryUrl + (repositoryUrl.endsWith("/") ? "" : "/") + resourceName;
        HttpHead headMethod = new HttpHead(url);
        HttpResponse response = null;
        try {
            response = this.execute(headMethod);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), e);
        }
        catch (HttpException e) {
            throw new TransferFailedException(e.getMessage(), e);
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            String reasonPhrase = ", ReasonPhrase: " + response.getStatusLine().getReasonPhrase() + ".";
            switch (statusCode) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
                case 304: {
                    boolean bl = true;
                    return bl;
                }
                case -1: {
                    throw new TransferFailedException("Failed to transfer file: " + url + reasonPhrase);
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url + reasonPhrase);
                }
                case 401: {
                    throw new AuthorizationException("Not authorized " + reasonPhrase);
                }
                case 407: {
                    throw new AuthorizationException("Not authorized by proxy " + reasonPhrase);
                }
                case 404: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode + reasonPhrase);
        }
        finally {
            headMethod.abort();
        }
    }

    protected HttpResponse execute(HttpUriRequest httpMethod) throws HttpException, IOException {
        this.setParameters(httpMethod);
        this.setHeaders(httpMethod);
        this.client.getParams().setParameter("http.useragent", this.getUserAgent(httpMethod));
        ProxyInfo proxyInfo = this.getProxyInfo(this.getRepository().getProtocol(), this.getRepository().getHost());
        if (proxyInfo != null && proxyInfo.getUserName() != null && proxyInfo.getPassword() != null) {
            Credentials creds = proxyInfo.getNtlmHost() != null || proxyInfo.getNtlmDomain() != null ? new NTCredentials(proxyInfo.getUserName(), proxyInfo.getPassword(), proxyInfo.getNtlmHost(), proxyInfo.getNtlmDomain()) : new UsernamePasswordCredentials(proxyInfo.getUserName(), proxyInfo.getPassword());
            Header bs = new BasicScheme().authenticate(creds, httpMethod);
            httpMethod.addHeader("Proxy-Authorization", bs.getValue());
        }
        return this.client.execute(httpMethod, this.localContext);
    }

    protected void setParameters(HttpUriRequest method) {
        HttpMethodConfiguration config;
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config != null) {
            HttpParams params = config.asMethodParams(method.getParams());
            if (config.isUsePreemptive() && this.authenticationInfo != null) {
                String username = this.authenticationInfo.getUserName();
                String password = this.authenticationInfo.getPassword();
                if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
                    BasicAuthCache authCache = new BasicAuthCache();
                    BasicScheme basicAuth = new BasicScheme();
                    HttpHost targetHost = new HttpHost(this.repository.getHost(), this.repository.getPort(), this.repository.getProtocol());
                    authCache.put(targetHost, basicAuth);
                    this.localContext = new BasicHttpContext();
                    this.localContext.setAttribute("http.auth.auth-cache", authCache);
                }
            }
            if (params != null) {
                method.setParams(params);
            }
        }
        if (config == null) {
            int readTimeout = this.getReadTimeout();
            method.getParams().setParameter("http.socket.timeout", readTimeout);
        }
    }

    protected void setHeaders(HttpUriRequest method) {
        Header[] headers;
        HttpMethodConfiguration config;
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config == null || config.isUseDefaultHeaders()) {
            method.addHeader("Cache-control", "no-cache");
            method.addHeader("Cache-store", "no-store");
            method.addHeader("Pragma", "no-cache");
            method.addHeader("Expires", "0");
            method.addHeader("Accept-Encoding", "gzip");
        }
        if (this.httpHeaders != null) {
            for (Map.Entry<Object, Object> entry : this.httpHeaders.entrySet()) {
                method.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Header[] headerArray = headers = config == null ? null : config.asRequestHeaders();
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                method.addHeader(headers[i]);
            }
        }
    }

    protected String getUserAgent(HttpUriRequest method) {
        HttpMethodConfiguration config;
        String value;
        if (this.httpHeaders != null && (value = (String)this.httpHeaders.get("User-Agent")) != null) {
            return value;
        }
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config != null) {
            return (String)config.getHeaders().get("User-Agent");
        }
        return null;
    }

    protected String getURL(Repository repository) {
        return repository.getUrl();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        InputStream is;
        Header contentEncoding;
        HttpResponse response;
        Resource resource = inputData.getResource();
        String repositoryUrl = this.getRepository().getUrl();
        String url = repositoryUrl + (repositoryUrl.endsWith("/") ? "" : "/") + resource.getName();
        this.getMethod = new HttpGet(url);
        long timestamp = resource.getLastModified();
        if (timestamp > 0L) {
            SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            fmt.setTimeZone(GMT_TIME_ZONE);
            BasicHeader hdr = new BasicHeader("If-Modified-Since", fmt.format(new Date(timestamp)));
            this.fireTransferDebug("sending ==> " + hdr + "(" + timestamp + ")");
            this.getMethod.addHeader(hdr);
        }
        try {
            response = this.execute(this.getMethod);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException(e.getMessage(), e);
        }
        catch (HttpException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException(e.getMessage(), e);
        }
        int statusCode = response.getStatusLine().getStatusCode();
        String reasonPhrase = ", ReasonPhrase:" + response.getStatusLine().getReasonPhrase() + ".";
        this.fireTransferDebug(url + " - Status code: " + statusCode + reasonPhrase);
        switch (statusCode) {
            case 200: {
                break;
            }
            case 304: {
                return;
            }
            case -1: {
                TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + " " + reasonPhrase);
                this.fireTransferError(resource, e, 5);
                throw e;
            }
            case 403: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Access denied to: " + url + " " + reasonPhrase);
            }
            case 401: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Not authorized " + reasonPhrase);
            }
            case 407: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Not authorized by proxy " + reasonPhrase);
            }
            case 404: {
                throw new ResourceDoesNotExistException("File: " + url + " " + reasonPhrase);
            }
            default: {
                this.cleanupGetTransfer(resource);
                TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode + " " + reasonPhrase);
                this.fireTransferError(resource, e, 5);
                throw e;
            }
        }
        Header contentLengthHeader = response.getFirstHeader("Content-Length");
        if (contentLengthHeader != null) {
            try {
                long contentLength = Long.parseLong(contentLengthHeader.getValue());
                resource.setContentLength(contentLength);
            }
            catch (NumberFormatException e) {
                this.fireTransferDebug("error parsing content length header '" + contentLengthHeader.getValue() + "' " + e);
            }
        }
        Header lastModifiedHeader = response.getFirstHeader("Last-Modified");
        long lastModified = 0L;
        if (lastModifiedHeader != null) {
            try {
                lastModified = DateUtils.parseDate(lastModifiedHeader.getValue()).getTime();
                resource.setLastModified(lastModified);
            }
            catch (DateParseException e) {
                this.fireTransferDebug("Unable to parse last modified header");
            }
            this.fireTransferDebug("last-modified = " + lastModifiedHeader.getValue() + " (" + lastModified + ")");
        }
        boolean isGZipped = (contentEncoding = response.getFirstHeader("Content-Encoding")) == null ? false : "gzip".equalsIgnoreCase(contentEncoding.getValue());
        try {
            is = response.getEntity().getContent();
            if (isGZipped) {
                is = new GZIPInputStream(is);
            }
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            String msg = "Error occurred while retrieving from remote repository " + this.getRepository() + ": " + e.getMessage();
            throw new TransferFailedException(msg, e);
        }
        inputData.setInputStream(is);
    }

    protected void cleanupGetTransfer(Resource resource) {
        if (this.getMethod != null) {
            this.getMethod.abort();
        }
    }

    public void putFromStream(InputStream stream, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.putFromStream(stream, destination, -1L, -1L);
    }

    protected void putFromStream(InputStream stream, Resource resource) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.putFromStream(stream, resource.getName(), -1L, -1L);
    }

    public Properties getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Properties httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new IllegalStateException("this wagon http client must not use fillOutputData");
    }

    static {
        useClientManagerPooled = Boolean.valueOf(System.getProperty("maven.wagon.http.pool", "true"));
        sslInsecure = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.insecure", "false"));
        IGNORE_SSL_VALIDITY_DATES = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.ignore.validity.dates", "false"));
        sslAllowAll = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.allowall", "false"));
        if (!useClientManagerPooled) {
            System.out.println("http connection pool disabled in wagon http");
        } else {
            PoolingClientConnectionManager poolingClientConnectionManager = new PoolingClientConnectionManager(AbstractHttpClientWagon.createSchemeRegistry());
            int maxPerRoute = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.maxPerRoute", "20"));
            poolingClientConnectionManager.setDefaultMaxPerRoute(maxPerRoute);
            int maxTotal = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.maxTotal", "40"));
            poolingClientConnectionManager.setDefaultMaxPerRoute(maxPerRoute);
            poolingClientConnectionManager.setMaxTotal(maxTotal);
            connectionManagerPooled = poolingClientConnectionManager;
        }
    }

    private static class RelaxedHostNameVerifier
    implements X509HostnameVerifier {
        private RelaxedHostNameVerifier() {
        }

        public void verify(String s, SSLSocket sslSocket) throws IOException {
        }

        public void verify(String s, X509Certificate x509Certificate) throws SSLException {
        }

        public void verify(String s, String[] strings, String[] strings1) throws SSLException {
        }

        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    private final class RequestEntityImplementation
    extends AbstractHttpEntity {
        private static final int BUFFER_SIZE = 2048;
        private final Resource resource;
        private final Wagon wagon;
        private ByteBuffer byteBuffer;
        private File source;
        private long length = -1L;

        private RequestEntityImplementation(InputStream stream, Resource resource, Wagon wagon, File source) throws TransferFailedException {
            if (source != null) {
                this.source = source;
            } else {
                try {
                    byte[] bytes = IOUtil.toByteArray(stream);
                    this.byteBuffer = ByteBuffer.allocate(bytes.length);
                    this.byteBuffer.put(bytes);
                }
                catch (IOException e) {
                    throw new TransferFailedException(e.getMessage(), e);
                }
            }
            this.resource = resource;
            this.length = resource == null ? -1L : resource.getContentLength();
            this.wagon = wagon;
        }

        public long getContentLength() {
            return this.length;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            if (this.source != null) {
                return new FileInputStream(this.source);
            }
            return new ByteArrayInputStream(this.byteBuffer.array());
        }

        public boolean isRepeatable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream outstream) throws IOException {
            block8: {
                if (outstream == null) {
                    throw new IllegalArgumentException("Output stream may not be null");
                }
                TransferEvent transferEvent = new TransferEvent(this.wagon, this.resource, 3, 6);
                transferEvent.setTimestamp(System.currentTimeMillis());
                InputStream instream = this.source != null ? new FileInputStream(this.source) : new ByteArrayInputStream(this.byteBuffer.array());
                try {
                    int l;
                    byte[] buffer = new byte[2048];
                    if (this.length < 0L) {
                        int l2;
                        while ((l2 = instream.read(buffer)) != -1) {
                            AbstractHttpClientWagon.this.fireTransferProgress(transferEvent, buffer, -1);
                            outstream.write(buffer, 0, l2);
                        }
                        break block8;
                    }
                    for (long remaining = this.length; remaining > 0L; remaining -= (long)l) {
                        l = instream.read(buffer, 0, (int)Math.min(2048L, remaining));
                        if (l == -1) {
                            break;
                        }
                        AbstractHttpClientWagon.this.fireTransferProgress(transferEvent, buffer, (int)Math.min(2048L, remaining));
                        outstream.write(buffer, 0, l);
                    }
                }
                finally {
                    instream.close();
                }
            }
        }

        public boolean isStreaming() {
            return true;
        }
    }
}

