/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http4;

import com.mobidevelop.robovm.org.apache.http.conn.ConnectTimeoutException;
import com.mobidevelop.robovm.org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import com.mobidevelop.robovm.org.apache.http.params.HttpParams;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import org.codehaus.plexus.util.StringUtils;

class ConfigurableSSLSocketFactoryDecorator
implements SchemeLayeredSocketFactory {
    private final SchemeLayeredSocketFactory sslSocketFactory;

    public ConfigurableSSLSocketFactoryDecorator(SchemeLayeredSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public Socket createSocket(HttpParams params) throws IOException {
        return this.enableSslProtocols(this.sslSocketFactory.createSocket(params));
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpParams params) throws IOException, UnknownHostException {
        return this.enableSslProtocols(this.sslSocketFactory.createLayeredSocket(socket, target, port, params));
    }

    public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        return this.sslSocketFactory.connectSocket(sock, remoteAddress, localAddress, params);
    }

    public boolean isSecure(Socket sock) throws IllegalArgumentException {
        return this.sslSocketFactory.isSecure(sock);
    }

    protected Socket enableSslProtocols(Socket socket) {
        String httpsProtocols = System.getProperty("https.protocols");
        if (StringUtils.isNotEmpty(httpsProtocols)) {
            String[] protocols = StringUtils.split(httpsProtocols, ",");
            if (socket instanceof SSLSocket) {
                ((SSLSocket)socket).setEnabledProtocols(protocols);
            }
        }
        return socket;
    }
}

