/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robovm.compiler.AbstractMethodCompiler;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.Bro;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.MarshalerLookup;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.llvm.AggregateType;
import org.robovm.compiler.llvm.Alloca;
import org.robovm.compiler.llvm.ArrayType;
import org.robovm.compiler.llvm.Bitcast;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.DataLayout;
import org.robovm.compiler.llvm.Fpext;
import org.robovm.compiler.llvm.Fptrunc;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.GlobalRef;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.IntegerType;
import org.robovm.compiler.llvm.Inttoptr;
import org.robovm.compiler.llvm.Load;
import org.robovm.compiler.llvm.PackedStructureType;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.PrimitiveType;
import org.robovm.compiler.llvm.Ptrtoint;
import org.robovm.compiler.llvm.Sext;
import org.robovm.compiler.llvm.Store;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Trunc;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VectorStructureType;
import org.robovm.compiler.llvm.Zext;
import org.robovm.compiler.trampoline.Invokestatic;
import org.robovm.compiler.trampoline.LdcClass;
import soot.DoubleType;
import soot.FloatType;
import soot.LongType;
import soot.PrimType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.VoidType;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationTag;

public abstract class BroMethodCompiler
extends AbstractMethodCompiler {
    private final List<String> cWrapperFunctions = new ArrayList<String>();

    public BroMethodCompiler(Config config) {
        super(config);
    }

    @Override
    public void reset(Clazz clazz) {
        this.cWrapperFunctions.clear();
        super.reset(clazz);
    }

    public List<String> getCWrapperFunctions() {
        return this.cWrapperFunctions;
    }

    protected boolean requiresCWrapper(SootMethod method) {
        if (Bro.isPassByValue(method)) {
            return true;
        }
        if (Annotations.hasVariadicAnnotation(method)) {
            return true;
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            if (!Bro.isPassByValue(method, i)) continue;
            return true;
        }
        return false;
    }

    protected Value ldcClass(Function fn, String name, Value env) {
        if (Types.isArray(name) && Types.isPrimitiveBaseType(name)) {
            String primitiveDesc = name.substring(name.length() - 1);
            Variable result = fn.newVariable(Types.OBJECT_PTR);
            fn.add(new Load(result, new ConstantBitcast(new GlobalRef("array_" + primitiveDesc, Types.CLASS_PTR), new PointerType(Types.OBJECT_PTR))));
            return result.ref();
        }
        FunctionRef ldcClassFn = null;
        if (name.equals(this.className)) {
            ldcClassFn = FunctionBuilder.ldcInternal(this.className).ref();
        } else {
            LdcClass trampoline = new LdcClass(this.className, name);
            this.trampolines.add(trampoline);
            ldcClassFn = trampoline.getFunctionRef();
        }
        return Functions.call(fn, (Value)ldcClassFn, env);
    }

    protected Value marshalNativeToPrimitive(Function fn, SootMethod method, int paramIndex, Value value) {
        soot.Type type = method.getParameterType(paramIndex);
        if (Annotations.hasPointerAnnotation(method, paramIndex)) {
            value = this.marshalPointerToLong(fn, value);
        } else if (Annotations.hasMachineSizedFloatAnnotation(method, paramIndex) && type.equals(DoubleType.v())) {
            value = this.marshalMachineSizedFloatToDouble(fn, value);
        } else if (Annotations.hasMachineSizedFloatAnnotation(method, paramIndex) && type.equals(FloatType.v())) {
            value = this.marshalMachineSizedFloatToFloat(fn, value);
        } else if (Annotations.hasMachineSizedSIntAnnotation(method, paramIndex) && type.equals(LongType.v())) {
            value = this.marshalMachineSizedSIntToLong(fn, value);
        } else if (Annotations.hasMachineSizedUIntAnnotation(method, paramIndex) && type.equals(LongType.v())) {
            value = this.marshalMachineSizedUIntToLong(fn, value);
        }
        return value;
    }

    protected Value marshalPrimitiveToNative(Function fn, SootMethod method, int paramIndex, Value value) {
        soot.Type type = method.getParameterType(paramIndex);
        if (Annotations.hasPointerAnnotation(method, paramIndex)) {
            value = this.marshalLongToPointer(fn, value);
        } else if (Annotations.hasMachineSizedFloatAnnotation(method, paramIndex) && type.equals(DoubleType.v())) {
            value = this.marshalDoubleToMachineSizedFloat(fn, value);
        } else if (Annotations.hasMachineSizedFloatAnnotation(method, paramIndex) && type.equals(FloatType.v())) {
            value = this.marshalFloatToMachineSizedFloat(fn, value);
        } else if (Annotations.hasMachineSizedSIntAnnotation(method, paramIndex) && type.equals(LongType.v())) {
            value = this.marshalLongToMachineSizedInt(fn, value);
        } else if (Annotations.hasMachineSizedUIntAnnotation(method, paramIndex) && type.equals(LongType.v())) {
            value = this.marshalLongToMachineSizedInt(fn, value);
        }
        return value;
    }

    protected Value marshalNativeToPrimitive(Function fn, SootMethod method, Value value) {
        soot.Type type = method.getReturnType();
        if (Annotations.hasPointerAnnotation(method)) {
            value = this.marshalPointerToLong(fn, value);
        } else if (Annotations.hasMachineSizedFloatAnnotation(method) && type.equals(DoubleType.v())) {
            value = this.marshalMachineSizedFloatToDouble(fn, value);
        } else if (Annotations.hasMachineSizedFloatAnnotation(method) && type.equals(FloatType.v())) {
            value = this.marshalMachineSizedFloatToFloat(fn, value);
        } else if (Annotations.hasMachineSizedSIntAnnotation(method) && type.equals(LongType.v())) {
            value = this.marshalMachineSizedSIntToLong(fn, value);
        } else if (Annotations.hasMachineSizedUIntAnnotation(method) && type.equals(LongType.v())) {
            value = this.marshalMachineSizedUIntToLong(fn, value);
        }
        return value;
    }

    protected Value marshalPrimitiveToNative(Function fn, SootMethod method, Value value) {
        soot.Type type = method.getReturnType();
        if (Annotations.hasPointerAnnotation(method)) {
            value = this.marshalLongToPointer(fn, value);
        } else if (Annotations.hasMachineSizedFloatAnnotation(method) && type.equals(DoubleType.v())) {
            value = this.marshalDoubleToMachineSizedFloat(fn, value);
        } else if (Annotations.hasMachineSizedFloatAnnotation(method) && type.equals(FloatType.v())) {
            value = this.marshalFloatToMachineSizedFloat(fn, value);
        } else if (Annotations.hasMachineSizedSIntAnnotation(method) && type.equals(LongType.v())) {
            value = this.marshalLongToMachineSizedInt(fn, value);
        } else if (Annotations.hasMachineSizedUIntAnnotation(method) && type.equals(LongType.v())) {
            value = this.marshalLongToMachineSizedInt(fn, value);
        }
        return value;
    }

    protected Value marshalNativeToObject(Function fn, MarshalerLookup.MarshalerMethod marshalerMethod, MarshaledArg marshaledArg, Value env, String valueClassName, Value nativeValue, long flags) {
        if (nativeValue.getType() instanceof StructureType) {
            nativeValue = this.createStackCopy(fn, nativeValue);
        }
        Invokestatic invokestatic = marshalerMethod.getInvokeStatic(this.sootMethod.getDeclaringClass());
        this.trampolines.add(invokestatic);
        Value valueClass = this.ldcClass(fn, valueClassName, env);
        Variable handle = fn.newVariable(Type.I64);
        fn.add(new Ptrtoint(handle, nativeValue, Type.I64));
        Value object = Functions.call(fn, (Value)invokestatic.getFunctionRef(), env, valueClass, handle.ref(), new IntegerConstant(flags));
        if (marshaledArg != null) {
            marshaledArg.handle = handle.ref();
            marshaledArg.object = object;
        }
        return object;
    }

    protected Value createStackCopy(Function fn, Value value) {
        Variable stackCopy = fn.newVariable(new PointerType(value.getType()));
        fn.add(new Alloca(stackCopy, value.getType()));
        fn.add(new Store(value, stackCopy.ref()));
        return stackCopy.ref();
    }

    protected Value marshalNativeToValueObject(Function fn, MarshalerLookup.MarshalerMethod marshalerMethod, Value env, String valueClassName, Value nativeValue, long flags) {
        Invokestatic invokeToObject = marshalerMethod.getInvokeStatic(this.sootMethod.getDeclaringClass());
        this.trampolines.add(invokeToObject);
        Value valueClass = this.ldcClass(fn, valueClassName, env);
        nativeValue = this.marshalNativeToPrimitive(fn, marshalerMethod.getMethod(), 1, nativeValue);
        return Functions.call(fn, (Value)invokeToObject.getFunctionRef(), env, valueClass, nativeValue, new IntegerConstant(flags));
    }

    private List<Value> arrayDimensionsValues(int[] dimensions) {
        ArrayList<Value> l = new ArrayList<Value>();
        for (int i = 0; i < dimensions.length; ++i) {
            l.add(new IntegerConstant(dimensions[i]));
        }
        return l;
    }

    protected Value marshalNativeToArray(Function fn, MarshalerLookup.MarshalerMethod marshalerMethod, Value env, String arrayClassName, Value nativeValue, long flags, int[] dimensions) {
        Invokestatic invokeToObject = marshalerMethod.getInvokeStatic(this.sootMethod.getDeclaringClass());
        this.trampolines.add(invokeToObject);
        Variable handle = fn.newVariable(Type.I64);
        fn.add(new Ptrtoint(handle, nativeValue, Type.I64));
        Value valueClass = this.ldcClass(fn, arrayClassName, env);
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(env);
        args.add(valueClass);
        args.add(handle.ref());
        args.add(new IntegerConstant(flags));
        args.addAll(this.arrayDimensionsValues(dimensions));
        return Functions.call(fn, (Value)invokeToObject.getFunctionRef(), args);
    }

    protected Value marshalPointerToLong(Function fn, Value pointer) {
        Variable result = fn.newVariable(Type.I64);
        fn.add(new Ptrtoint(result, pointer, Type.I64));
        return result.ref();
    }

    protected Value marshalMachineSizedSIntToLong(Function fn, Value value) {
        if (this.config.getArch().is32Bit()) {
            Variable result = fn.newVariable(Type.I64);
            fn.add(new Sext(result, value, Type.I64));
            return result.ref();
        }
        return value;
    }

    protected Value marshalMachineSizedUIntToLong(Function fn, Value value) {
        if (this.config.getArch().is32Bit()) {
            Variable result = fn.newVariable(Type.I64);
            fn.add(new Zext(result, value, Type.I64));
            return result.ref();
        }
        return value;
    }

    protected Value marshalMachineSizedFloatToDouble(Function fn, Value value) {
        if (this.config.getArch().is32Bit()) {
            Variable result = fn.newVariable(Type.DOUBLE);
            fn.add(new Fpext(result, value, Type.DOUBLE));
            return result.ref();
        }
        return value;
    }

    protected Value marshalMachineSizedFloatToFloat(Function fn, Value value) {
        if (!this.config.getArch().is32Bit()) {
            Variable result = fn.newVariable(Type.FLOAT);
            fn.add(new Fptrunc(result, value, Type.FLOAT));
            return result.ref();
        }
        return value;
    }

    protected Value marshalObjectToNative(Function fn, MarshalerLookup.MarshalerMethod marshalerMethod, MarshaledArg marshaledArg, Type nativeType, Value env, Value object, long flags) {
        Invokestatic invokestatic = marshalerMethod.getInvokeStatic(this.sootMethod.getDeclaringClass());
        this.trampolines.add(invokestatic);
        Value handle = Functions.call(fn, (Value)invokestatic.getFunctionRef(), env, object, new IntegerConstant(flags));
        Variable nativeValue = fn.newVariable(nativeType);
        if (nativeType instanceof StructureType || nativeType instanceof ArrayType) {
            Variable tmp = fn.newVariable(new PointerType(nativeType));
            fn.add(new Inttoptr(tmp, handle, tmp.getType()));
            fn.add(new Load(nativeValue, tmp.ref()));
        } else {
            fn.add(new Inttoptr(nativeValue, handle, nativeType));
        }
        if (marshaledArg != null) {
            marshaledArg.handle = handle;
            marshaledArg.object = object;
        }
        return nativeValue.ref();
    }

    protected Value marshalValueObjectToNative(Function fn, MarshalerLookup.MarshalerMethod marshalerMethod, Type nativeType, Value env, Value object, long flags) {
        Invokestatic invokestatic = marshalerMethod.getInvokeStatic(this.sootMethod.getDeclaringClass());
        this.trampolines.add(invokestatic);
        Value result = Functions.call(fn, (Value)invokestatic.getFunctionRef(), env, object, new IntegerConstant(flags));
        return this.marshalPrimitiveToNative(fn, marshalerMethod.getMethod(), result);
    }

    protected void marshalArrayToNative(Function fn, MarshalerLookup.MarshalerMethod marshalerMethod, Value env, Value object, Value destPtr, long flags, int[] dimensions) {
        Invokestatic invokestatic = marshalerMethod.getInvokeStatic(this.sootMethod.getDeclaringClass());
        this.trampolines.add(invokestatic);
        Variable handle = fn.newVariable(Type.I64);
        fn.add(new Ptrtoint(handle, destPtr, Type.I64));
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(env);
        args.add(object);
        args.add(handle.ref());
        args.add(new IntegerConstant(flags));
        args.addAll(this.arrayDimensionsValues(dimensions));
        Functions.call(fn, (Value)invokestatic.getFunctionRef(), args);
    }

    protected Value marshalLongToPointer(Function fn, Value handle) {
        Variable result = fn.newVariable(Type.I8_PTR);
        fn.add(new Inttoptr(result, handle, Type.I8_PTR));
        return result.ref();
    }

    protected Value marshalLongToMachineSizedInt(Function fn, Value value) {
        if (this.config.getArch().is32Bit()) {
            Variable result = fn.newVariable(Type.I32);
            fn.add(new Trunc(result, value, Type.I32));
            return result.ref();
        }
        return value;
    }

    protected Value marshalDoubleToMachineSizedFloat(Function fn, Value value) {
        if (this.config.getArch().is32Bit()) {
            Variable result = fn.newVariable(Type.FLOAT);
            fn.add(new Fptrunc(result, value, Type.FLOAT));
            return result.ref();
        }
        return value;
    }

    protected Value marshalFloatToMachineSizedFloat(Function fn, Value value) {
        if (!this.config.getArch().is32Bit()) {
            Variable result = fn.newVariable(Type.DOUBLE);
            fn.add(new Fpext(result, value, Type.DOUBLE));
            return result.ref();
        }
        return value;
    }

    private Type getReturnType(String anno, SootMethod method) {
        soot.Type sootType = method.getReturnType();
        if (Annotations.hasPointerAnnotation(method)) {
            if (!sootType.equals(LongType.v())) {
                throw new IllegalArgumentException(anno + " annotated method " + method + " must return long when annotated with @Pointer");
            }
            return Type.I8_PTR;
        }
        if (Annotations.hasMachineSizedFloatAnnotation(method)) {
            if (!sootType.equals(DoubleType.v()) && !sootType.equals(FloatType.v())) {
                throw new IllegalArgumentException(anno + " annotated method " + method + " must return float or double when annotated with @MachineSizedFloat");
            }
            return this.config.getArch().is32Bit() ? Type.FLOAT : Type.DOUBLE;
        }
        if (Annotations.hasMachineSizedSIntAnnotation(method) || Annotations.hasMachineSizedUIntAnnotation(method)) {
            if (!sootType.equals(LongType.v())) {
                throw new IllegalArgumentException(anno + " annotated method " + method + " must return long when annotated with @MachineSizedSInt or @MachineSizedUInt");
            }
            return this.config.getArch().is32Bit() ? Type.I32 : Type.I64;
        }
        if (Types.isStruct(sootType)) {
            if (!Bro.isPassByValue(method)) {
                return new PointerType(this.getStructType(sootType));
            }
            return this.getStructType(sootType);
        }
        if (Types.isNativeObject(sootType)) {
            return Type.I8_PTR;
        }
        if (sootType instanceof PrimType || sootType == VoidType.v()) {
            return Types.getType(sootType);
        }
        MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method));
        if (marshalerMethod instanceof MarshalerLookup.ValueMarshalerMethod) {
            return ((MarshalerLookup.ValueMarshalerMethod)marshalerMethod).getNativeType(this.config.getArch());
        }
        return Type.I8_PTR;
    }

    private Type getParameterType(String anno, SootMethod method, int i) {
        soot.Type sootType = method.getParameterType(i);
        if (Annotations.hasPointerAnnotation(method, i)) {
            if (!sootType.equals(LongType.v())) {
                throw new IllegalArgumentException("Parameter " + (i + 1) + " of " + anno + " annotated method " + method + " must be of type long when annotated with @Pointer.");
            }
            return Type.I8_PTR;
        }
        if (Annotations.hasMachineSizedFloatAnnotation(method, i)) {
            if (!sootType.equals(DoubleType.v()) && !sootType.equals(FloatType.v())) {
                throw new IllegalArgumentException("Parameter " + (i + 1) + " of " + anno + " annotated method " + method + " must be of type float or double when annotated with @MachineSizedFloat.");
            }
            return this.config.getArch().is32Bit() ? Type.FLOAT : Type.DOUBLE;
        }
        if (Annotations.hasMachineSizedSIntAnnotation(method, i) || Annotations.hasMachineSizedUIntAnnotation(method, i)) {
            if (!sootType.equals(LongType.v())) {
                throw new IllegalArgumentException("Parameter " + (i + 1) + " of " + anno + " annotated method " + method + " must be of type long when annotated with @MachineSizedSInt or @MachineSizedUInt");
            }
            return this.config.getArch().is32Bit() ? Type.I32 : Type.I64;
        }
        if (Annotations.hasStructRetAnnotation(method, i)) {
            if (i > 0) {
                throw new IllegalArgumentException("Parameter " + (i + 1) + " of " + anno + " annotated method " + method + " cannot be annotated with @StructRet. Only the first parameter may have this annotation.");
            }
            if (!Types.isStruct(sootType)) {
                throw new IllegalArgumentException("Parameter " + (i + 1) + " of " + anno + " annotated method " + method + " must be a sub class of Struct when annotated with @StructRet.");
            }
            return new PointerType(this.getStructType(sootType));
        }
        if (Types.isStruct(sootType)) {
            StructureType structType = this.getStructType(sootType);
            if (Annotations.hasByValAnnotation(method, i)) {
                return this.getStructType(sootType);
            }
            return new PointerType(structType);
        }
        if (Types.isNativeObject(sootType)) {
            return Type.I8_PTR;
        }
        if (sootType instanceof PrimType) {
            return Types.getType(sootType);
        }
        MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, i));
        if (marshalerMethod instanceof MarshalerLookup.ValueMarshalerMethod) {
            return ((MarshalerLookup.ValueMarshalerMethod)marshalerMethod).getNativeType(this.config.getArch());
        }
        return Type.I8_PTR;
    }

    public FunctionType getBridgeFunctionType(SootMethod method, boolean dynamic, boolean considerVariadic) {
        return this.getBridgeOrCallbackFunctionType("@Bridge", method, dynamic, considerVariadic);
    }

    public FunctionType getCallbackFunctionType(SootMethod method, boolean considerVariadic) {
        return this.getBridgeOrCallbackFunctionType("@Callback", method, false, considerVariadic);
    }

    private FunctionType getBridgeOrCallbackFunctionType(String anno, SootMethod method, boolean dynamic, boolean considerVariadic) {
        int i;
        Type returnType = this.getReturnType(anno, method);
        boolean varargs = considerVariadic && Annotations.hasVariadicAnnotation(method);
        int variadicIndex = varargs ? Annotations.getVariadicParameterIndex(method) : Integer.MAX_VALUE;
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        int n = i = dynamic ? 1 : 0;
        while (i < method.getParameterCount() && i != variadicIndex) {
            paramTypes.add(this.getParameterType(anno, method, i));
            ++i;
        }
        if (!method.isStatic()) {
            int idx = Annotations.hasStructRetAnnotation(method, 0) ? 1 : 0;
            RefType sootType = method.getDeclaringClass().getType();
            if (Types.isStruct(sootType)) {
                paramTypes.add(idx, new PointerType(this.getStructType(sootType)));
            } else if (Types.isNativeObject(sootType)) {
                paramTypes.add(idx, Type.I8_PTR);
            } else {
                throw new IllegalArgumentException("Receiver of non static " + anno + " method " + method + " must either be a Struct or a NativeObject");
            }
        }
        return new FunctionType(returnType, varargs, paramTypes.toArray(new Type[paramTypes.size()]));
    }

    public StructureType getStructType(soot.Type t) {
        return this.getStructType(((RefType)t).getSootClass());
    }

    public StructureType getStructType(SootClass clazz) {
        return this.getStructType(clazz, true);
    }

    private StructureType getStructType(SootClass clazz, boolean checkEmpty) {
        boolean singleIntStruct;
        Type[] result;
        SootClass superclass;
        int n = 0;
        for (SootMethod method : clazz.getMethods()) {
            n = Math.max(Bro.getStructMemberOffset(method) + 1, n);
        }
        StructureType superType = null;
        if (clazz.hasSuperclass() && !(superclass = clazz.getSuperclass()).getName().equals("org.robovm.rt.bro.Struct")) {
            superType = this.getStructType(superclass, false);
        }
        int ownMembersOffset = 0;
        int attributes = 0;
        if (superType != null) {
            ownMembersOffset = 1;
            result = new Type[n + 1];
            result[0] = superType;
        } else {
            result = new Type[n];
        }
        AnnotationTag vectorisedAnnotation = Annotations.getStructVectorisedAnnotation(clazz);
        AnnotationTag packedAnnotation = Annotations.getStructPackedAnnotation(clazz);
        if (vectorisedAnnotation != null && packedAnnotation != null) {
            throw new IllegalArgumentException("Struct class " + clazz + " cannot have both @Packed and @Vectorized same time");
        }
        if (vectorisedAnnotation != null && ownMembersOffset != 0) {
            throw new IllegalArgumentException("Struct class " + clazz + " cannot inherit struct when annotated @Vectorised");
        }
        int packedAllign = 0;
        if (packedAnnotation != null && (packedAllign = ((AnnotationIntElem)packedAnnotation.getElemAt(0)).getValue()) != 1 && packedAllign != 2 && packedAllign != 4) {
            throw new IllegalArgumentException("Struct class " + clazz + " has wrong @Packed annotation. Only 1,2,4 are allowed");
        }
        for (SootMethod method : clazz.getMethods()) {
            soot.Type sootType;
            int offset = Bro.getStructMemberOffset(method);
            if (offset == -1) continue;
            if (!method.isNative() || method.isStatic()) {
                throw new IllegalArgumentException("@StructMember annotated method " + method + " must be native and not static");
            }
            Type type = null;
            if (method.getParameterCount() == 0) {
                sootType = method.getReturnType();
                if (Annotations.hasPointerAnnotation(method) && !sootType.equals(LongType.v())) {
                    throw new IllegalArgumentException("@StructMember(" + offset + ") annotated getter " + method + " must be of type long when annotated with @Pointer");
                }
                if (Annotations.hasMachineSizedFloatAnnotation(method) && !sootType.equals(DoubleType.v()) && !sootType.equals(FloatType.v())) {
                    throw new IllegalArgumentException("@StructMember(" + offset + ") annotated getter " + method + " must be of type float or double when annotated with @MachineSizedFloat");
                }
                if ((Annotations.hasMachineSizedSIntAnnotation(method) || Annotations.hasMachineSizedUIntAnnotation(method)) && !sootType.equals(LongType.v())) {
                    throw new IllegalArgumentException("@StructMember(" + offset + ") annotated getter " + method + " must be of type long when annotated with @MachineSizedSInt or @MachineSizedUInt");
                }
                if (sootType instanceof soot.ArrayType && !Annotations.hasArrayAnnotation(method)) {
                    throw new IllegalArgumentException("@Array annotation expected on struct member getter " + method);
                }
            } else if (method.getParameterCount() == 1) {
                sootType = method.getParameterType(0);
                if (Annotations.hasPointerAnnotation(method, 0) && !sootType.equals(LongType.v())) {
                    throw new IllegalArgumentException("@StructMember(" + offset + ") annotated setter " + method + " must be of type long when annotated with @Pointer");
                }
                if (Annotations.hasMachineSizedFloatAnnotation(method, 0) && !sootType.equals(DoubleType.v()) && !sootType.equals(FloatType.v())) {
                    throw new IllegalArgumentException("@StructMember(" + offset + ") annotated setter " + method + " must be of type float or double when annotated with @MachineSizedFloat");
                }
                if ((Annotations.hasMachineSizedSIntAnnotation(method, 0) || Annotations.hasMachineSizedUIntAnnotation(method)) && !sootType.equals(LongType.v())) {
                    throw new IllegalArgumentException("@StructMember(" + offset + ") annotated setter " + method + " must be of type long when annotated with @MachineSizedSInt or @MachineSizedUInt");
                }
                if (sootType instanceof soot.ArrayType && !Annotations.hasArrayAnnotation(method, 0)) {
                    throw new IllegalArgumentException("@Array annotation expected on first parameter of struct member setter " + method);
                }
                soot.Type retType = method.getReturnType();
                if (!(retType.equals(VoidType.v()) || retType instanceof RefType && ((RefType)retType).getSootClass().equals(clazz))) {
                    throw new IllegalArgumentException("Setter " + method + " for @StructMember(" + offset + ")  must either return nothing or return a " + clazz);
                }
            } else {
                throw new IllegalArgumentException("@StructMember annotated method " + method + " has too many parameters");
            }
            type = this.getStructMemberType(method);
            int index = offset + ownMembersOffset;
            if (result[index] == null) {
                result[index] = type;
                continue;
            }
            if (type.equals(result[index])) continue;
            if (vectorisedAnnotation != null) {
                throw new IllegalArgumentException("Duplicate @StructMember(" + index + ") in @Vectorised structs (union in vector is not supported");
            }
            if (packedAnnotation != null) {
                throw new IllegalArgumentException("Duplicate @StructMember(" + index + ") in @Packed structs (union in packed structs is not supported");
            }
            result[index] = BroMethodCompiler.mergeStructMemberTypes(this.config.getDataLayout(), type, result[index]);
        }
        for (int i = ownMembersOffset; i < result.length; ++i) {
            if (result[i] != null) continue;
            throw new IllegalArgumentException("No @StructMember(" + i + ") defined in class " + clazz);
        }
        if (packedAnnotation != null && packedAllign != 1 && result.length > 1) {
            int packedStructOffset = 0;
            for (int i = ownMembersOffset; i < result.length; ++i) {
                Type item = result[i];
                int itemAlignment = this.config.getDataLayout().getAlignment(item);
                if (itemAlignment != 0 && packedStructOffset % itemAlignment != 0) {
                    attributes |= 1;
                }
                Type next = i + 1 < result.length ? result[i + 1] : result[0];
                result[i] = BroMethodCompiler.packStructMemberTypes(this.config.getDataLayout(), packedAllign, packedStructOffset, item, next);
                packedStructOffset += this.config.getDataLayout().getStoreSize(result[i]);
            }
        }
        if (!clazz.isAbstract() && checkEmpty && n == 0 && superType == null) {
            throw new IllegalArgumentException("Struct class " + clazz + " has no @StructMember annotated methods");
        }
        if (vectorisedAnnotation != null) {
            this.validateVectorStruct(clazz, result);
        }
        boolean bl = singleIntStruct = result.length == 1 && result[0] instanceof IntegerType && ((IntegerType)result[0]).getBits() <= 32;
        if (!singleIntStruct) {
            attributes |= 2;
        }
        if (vectorisedAnnotation != null) {
            return new VectorStructureType(ownMembersOffset, result);
        }
        if (packedAnnotation != null && result.length > 1) {
            return new PackedStructureType(ownMembersOffset, attributes, packedAllign, result);
        }
        return new StructureType(ownMembersOffset, attributes, result);
    }

    private Type validateVectorStruct(SootClass clazz, Type ... elements) {
        Type commonType = elements[0];
        for (Type type : elements) {
            if (type instanceof StructureType) {
                this.validateVectorStruct(clazz, ((StructureType)type).getTypes());
            } else if (type != Type.FLOAT && type != Type.DOUBLE && !(type instanceof IntegerType)) {
                throw new IllegalArgumentException("Struct class " + clazz + " has not supported @StructMember to be vectorized, problem with " + type);
            }
            if (commonType.equals(type)) continue;
            throw new IllegalArgumentException("Struct class " + clazz + " all elements required to be same type to be vectorized");
        }
        return commonType;
    }

    static Type mergeStructMemberTypes(DataLayout dataLayout, Type t1, Type t2) {
        int align1 = dataLayout.getAlignment(t1);
        int align2 = dataLayout.getAlignment(t2);
        int size1 = dataLayout.getStoreSize(t1);
        int size2 = dataLayout.getStoreSize(t2);
        Type result = align1 < align2 ? t2 : t1;
        int size = align1 < align2 ? size2 : size1;
        int pad = Math.max(size1, size2) - size;
        if (pad > 0) {
            return new StructureType(result, new ArrayType(pad, Type.I8));
        }
        return result;
    }

    static Type packStructMemberTypes(DataLayout dataLayout, int packAlign, int memberStructOffs, Type memberType, Type nextMemberType) {
        int memberSize = dataLayout.getStoreSize(memberType);
        int nextMemberAlign = Math.min(packAlign, dataLayout.getAlignment(nextMemberType));
        int pad = (nextMemberAlign - (memberStructOffs + memberSize) % nextMemberAlign) % nextMemberAlign;
        if (pad > 0) {
            return new PackedStructureType(memberType, pad == 1 ? Type.I8 : new ArrayType(pad, Type.I8));
        }
        return memberType;
    }

    protected static String getHiType(Type type) {
        if (type == Type.VOID) {
            return "void";
        }
        if (type instanceof PointerType || type instanceof AggregateType) {
            return "void*";
        }
        if (type instanceof IntegerType) {
            switch (((IntegerType)type).getBits()) {
                case 8: {
                    return "char";
                }
                case 16: {
                    return "short";
                }
                case 32: {
                    return "int";
                }
                case 64: {
                    return "long long";
                }
            }
        } else {
            if (type == Type.FLOAT) {
                return "float";
            }
            if (type == Type.DOUBLE) {
                return "double";
            }
        }
        throw new IllegalArgumentException("Cannot convert type " + type + " to C type");
    }

    protected static String getLoType(Type type, String base, int index, Map<String, String> typedefs) {
        if (type instanceof VectorStructureType) {
            String name = String.format("%s_%04d", base, index);
            StringBuilder sb = new StringBuilder();
            VectorStructureType st = (VectorStructureType)type;
            Type t = st.getTypeAt(0);
            if (st.isVectorArray()) {
                sb.append("typedef struct { ").append(BroMethodCompiler.getLoType(t, name, 0, typedefs)).append(" m[").append(st.getTypeCount()).append("];}");
            } else {
                sb.append("typedef __attribute__((__ext_vector_type__(").append(st.getTypeCount()).append("))) ").append(BroMethodCompiler.getLoType(t, name, 0, typedefs));
            }
            sb.append(" " + name + ";");
            typedefs.put(name, sb.toString());
            return name;
        }
        if (type instanceof StructureType) {
            String name = String.format("%s_%04d", base, index);
            StringBuilder sb = new StringBuilder();
            StructureType st = (StructureType)type;
            if (type instanceof PackedStructureType) {
                String packPragma = String.format("#pragma pack(push, %d)\n", ((PackedStructureType)st).getAlign());
                sb.append(packPragma);
            }
            sb.append("typedef struct {");
            for (int i = 0; i < st.getTypeCount(); ++i) {
                Type t = st.getTypeAt(i);
                StringBuilder dims = new StringBuilder();
                while (t instanceof ArrayType) {
                    ArrayType at = (ArrayType)t;
                    dims.append('[').append(at.getSize()).append(']');
                    t = ((ArrayType)t).getElementType();
                }
                sb.append(BroMethodCompiler.getLoType(t, name, i, typedefs)).append(" m" + i).append((CharSequence)dims).append(";");
            }
            sb.append("} " + name + ";");
            if (type instanceof PackedStructureType) {
                sb.append("\n#pragma pack(pop)");
            }
            typedefs.put(name, sb.toString());
            return name;
        }
        return BroMethodCompiler.getHiType(type);
    }

    public Type getStructMemberType(SootMethod method) {
        String methodType = Annotations.hasStructMemberAnnotation(method) ? "@StructMember" : "@GlobalValue";
        SootMethod getter = method.getParameterCount() == 0 ? method : null;
        SootMethod setter = getter == null ? method : null;
        soot.Type type = getter != null ? getter.getReturnType() : setter.getParameterType(0);
        Type memberType = null;
        if (getter != null && Annotations.hasPointerAnnotation(getter) || setter != null && Annotations.hasPointerAnnotation(setter, 0)) {
            memberType = Type.I8_PTR;
        } else if (getter != null && Annotations.hasMachineSizedFloatAnnotation(getter) || setter != null && Annotations.hasMachineSizedFloatAnnotation(setter, 0)) {
            memberType = this.config.getArch().is32Bit() ? Type.FLOAT : Type.DOUBLE;
        } else if (getter != null && (Annotations.hasMachineSizedSIntAnnotation(getter) || Annotations.hasMachineSizedUIntAnnotation(getter)) || setter != null && (Annotations.hasMachineSizedSIntAnnotation(setter, 0) || Annotations.hasMachineSizedUIntAnnotation(setter, 0))) {
            memberType = this.config.getArch().is32Bit() ? Type.I32 : Type.I64;
        } else if (type instanceof PrimType) {
            memberType = Types.getType(type);
        } else if (getter != null && Annotations.hasArrayAnnotation(getter) || setter != null && Annotations.hasArrayAnnotation(setter, 0)) {
            int[] dimensions;
            int[] nArray = dimensions = getter != null ? Bro.getArrayDimensions(getter) : Bro.getArrayDimensions(setter, 0);
            if (dimensions == null || dimensions.length == 0) {
                throw new IllegalArgumentException("No dimensions specified for @Array annotation on " + methodType + " " + (getter != null ? "getter" : "setter") + " " + method);
            }
            if (type instanceof soot.ArrayType && ((soot.ArrayType)type).numDimensions != dimensions.length) {
                throw new IllegalArgumentException("Mismatch in number of dimennsions for @Array annotation and type on " + methodType + " " + (getter != null ? "getter" : "setter") + " " + method);
            }
            Type baseType = null;
            if (type instanceof soot.ArrayType) {
                soot.ArrayType arrayType = (soot.ArrayType)type;
                if (Types.isStruct(arrayType.baseType)) {
                    try {
                        baseType = this.getStructType(arrayType.baseType);
                    }
                    catch (StackOverflowError e) {
                        throw new IllegalArgumentException("Struct type " + type + " refers to itself");
                    }
                } else {
                    baseType = Types.getType(arrayType.baseType);
                }
            } else if (Types.isStruct(type)) {
                try {
                    baseType = this.getStructType(type);
                }
                catch (StackOverflowError e) {
                    throw new IllegalArgumentException("Struct type " + type + " refers to itself");
                }
            } else if (type instanceof RefType) {
                MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(getter != null ? new MarshalerLookup.MarshalSite(getter) : new MarshalerLookup.MarshalSite(setter, 0));
                baseType = Types.getType(((MarshalerLookup.ArrayMarshalerMethod)marshalerMethod).getBaseType());
            }
            if (baseType == null) {
                throw new IllegalArgumentException("Arrays of " + type + " is not supported");
            }
            long total = dimensions[0];
            for (int i = 1; i < dimensions.length; ++i) {
                total *= (long)dimensions[i];
            }
            memberType = new ArrayType(total, baseType);
        } else if (Types.isStruct(type)) {
            boolean byVal;
            boolean bl = byVal = getter != null ? Bro.isPassByValue(getter) : Bro.isPassByValue(setter, 0);
            if (!byVal) {
                memberType = Type.I8_PTR;
            } else {
                try {
                    memberType = this.getStructType(type);
                }
                catch (StackOverflowError e) {
                    throw new IllegalArgumentException("Struct type " + type + " refers to itself");
                }
            }
        } else if (Types.isNativeObject(type)) {
            memberType = Type.I8_PTR;
        } else {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(getter != null ? new MarshalerLookup.MarshalSite(getter) : new MarshalerLookup.MarshalSite(setter, 0));
            memberType = marshalerMethod instanceof MarshalerLookup.ValueMarshalerMethod ? ((MarshalerLookup.ValueMarshalerMethod)marshalerMethod).getNativeType(this.config.getArch()) : Type.I8_PTR;
        }
        return memberType;
    }

    protected SootMethod createFakeStructRetMethod(SootMethod originalMethod) {
        ArrayList<soot.Type> newParameterTypes = new ArrayList<soot.Type>(originalMethod.getParameterTypes());
        newParameterTypes.add(0, originalMethod.getReturnType());
        SootMethod method = new SootMethod(originalMethod.getName(), newParameterTypes, VoidType.v(), originalMethod.getModifiers());
        method.setDeclaringClass(originalMethod.getDeclaringClass());
        method.setDeclared(true);
        Annotations.copyAnnotations(originalMethod, method, Annotations.Visibility.Any);
        Annotations.copyParameterAnnotations(originalMethod, method, 0, originalMethod.getParameterCount(), 1, Annotations.Visibility.Any);
        Annotations.addRuntimeVisibleParameterAnnotation(method, 0, "Lorg/robovm/rt/bro/annotation/StructRet;");
        return method;
    }

    protected Value loadValueForGetter(SootMethod method, Function fn, Type memberType, Value memberPtr, Value env, boolean dereference, long flags) {
        Variable tmp;
        soot.Type type = method.getReturnType();
        Value result = null;
        if (memberType instanceof StructureType) {
            result = memberPtr;
        } else if (memberType instanceof ArrayType) {
            result = memberPtr;
        } else if (dereference) {
            tmp = fn.newVariable(memberType);
            fn.add(new Load(tmp, memberPtr));
            result = tmp.ref();
        } else {
            tmp = fn.newVariable(memberType);
            fn.add(new Bitcast(tmp, memberPtr, tmp.getType()));
            result = tmp.ref();
        }
        if (Bro.needsMarshaler(type)) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method));
            String targetClassName = Types.getInternalName(type);
            result = memberType instanceof PrimitiveType ? this.marshalNativeToValueObject(fn, marshalerMethod, env, targetClassName, result, flags) : (memberType instanceof ArrayType ? this.marshalNativeToArray(fn, marshalerMethod, env, targetClassName, result, flags, Bro.getArrayDimensions(method)) : this.marshalNativeToObject(fn, marshalerMethod, null, env, targetClassName, result, flags));
        } else {
            result = this.marshalNativeToPrimitive(fn, method, result);
        }
        return result;
    }

    protected void storeValueForSetter(SootMethod method, Function function, Type memberType, Value memberPtr, Value env, Value value, long flags) {
        soot.Type type = method.getParameterType(0);
        if (Bro.needsMarshaler(type)) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, 0));
            if (memberType instanceof PrimitiveType) {
                value = this.marshalValueObjectToNative(function, marshalerMethod, memberType, env, value, flags);
            } else {
                if (memberType instanceof StructureType || memberType instanceof ArrayType) {
                    Functions.call(function, (Value)Functions.CHECK_NULL, env, value);
                }
                if (memberType instanceof ArrayType) {
                    this.marshalArrayToNative(function, marshalerMethod, env, value, memberPtr, flags, Bro.getArrayDimensions(method, 0));
                    value = null;
                } else {
                    value = this.marshalObjectToNative(function, marshalerMethod, null, memberType, env, value, flags);
                }
            }
        } else {
            value = this.marshalPrimitiveToNative(function, method, 0, value);
        }
        if (value != null) {
            function.add(new Store(value, memberPtr));
        }
    }

    public static class MarshaledArg {
        public Value object;
        public Value handle;
        public int paramIndex;
    }
}

