/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import org.robovm.compiler.Annotations;
import org.robovm.compiler.BroMethodCompiler;
import org.robovm.compiler.Functions;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.llvm.Br;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.Icmp;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.Load;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Unreachable;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;
import soot.SootMethod;
import soot.VoidType;
import soot.tagkit.AnnotationTag;

public class GlobalValueMethodCompiler
extends BroMethodCompiler {
    public GlobalValueMethodCompiler(Config config) {
        super(config);
    }

    private void validateGlobalValueMethod(SootMethod method, AnnotationTag globalValueAnnotation) {
        boolean dereference;
        if (!method.isStatic()) {
            throw new IllegalArgumentException("@GlobalValue annotated method " + method + " must be static");
        }
        if (!method.isNative()) {
            throw new IllegalArgumentException("@GlobalValue annotated method " + method + " must be native");
        }
        if (!(method.getReturnType() != VoidType.v() && method.getParameterCount() == 0 || method.getReturnType() == VoidType.v() && method.getParameterCount() == 1)) {
            throw new IllegalArgumentException("Invalid signature for @GlobalValue annotated method " + method + ". It should either take 0 arguments and return a non-void type or take 1 argument and return void");
        }
        if (method.getReturnType() == VoidType.v() && !(dereference = Annotations.readBooleanElem(globalValueAnnotation, "dereference", true))) {
            throw new IllegalArgumentException("Only @GlobalValue getter methods are allowed to have dereference=false");
        }
    }

    @Override
    protected Function doCompile(ModuleBuilder moduleBuilder, SootMethod method) {
        AnnotationTag globalValueAnnotation = Annotations.getAnnotation(method, "Lorg/robovm/rt/bro/annotation/GlobalValue;");
        this.validateGlobalValueMethod(method, globalValueAnnotation);
        boolean optional = Annotations.readBooleanElem(globalValueAnnotation, "optional", false);
        boolean dereference = Annotations.readBooleanElem(globalValueAnnotation, "dereference", true);
        Function fn = this.createMethodFunction(method);
        moduleBuilder.addFunction(fn);
        Type valueType = this.getStructMemberType(method);
        Variable valuePtr = fn.newVariable(new PointerType(valueType));
        Global valuePtrPtr = new Global(Symbols.globalValuePtrSymbol(method), Linkage._private, new NullConstant(Type.I8_PTR));
        moduleBuilder.addGlobal(valuePtrPtr);
        fn.add(new Load(valuePtr, new ConstantBitcast(valuePtrPtr.ref(), new PointerType(valuePtr.getType()))));
        Label nullLabel = new Label();
        Label notNullLabel = new Label();
        Variable nullCheck = fn.newVariable(Type.I1);
        fn.add(new Icmp(nullCheck, Icmp.Condition.eq, valuePtr.ref(), new NullConstant(valuePtr.getType())));
        fn.add(new Br(nullCheck.ref(), fn.newBasicBlockRef(nullLabel), fn.newBasicBlockRef(notNullLabel)));
        fn.newBasicBlock(nullLabel);
        VariableRef env = fn.getParameterRef(0);
        Functions.call(fn, (Value)Functions.BC_THROW_UNSATISIFED_LINK_ERROR, env, moduleBuilder.getString(String.format((optional ? "Optional " : "") + "@GlobalValue method %s.%s%s not bound", this.className, method.getName(), Types.getDescriptor(method))));
        fn.add(new Unreachable());
        fn.newBasicBlock(notNullLabel);
        if (method.getParameterCount() == 0) {
            Value result = this.loadValueForGetter(method, fn, valueType, valuePtr.ref(), env, dereference, 3L);
            fn.add(new Ret(result));
        } else {
            VariableRef value = fn.getParameterRef(1);
            this.storeValueForSetter(method, fn, valueType, valuePtr.ref(), env, value, 3L);
            fn.add(new Ret());
        }
        return fn;
    }
}

