/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.robovm.compiler.Access;
import org.robovm.compiler.ClassCompiler;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionAttribute;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Unreachable;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.trampoline.Anewarray;
import org.robovm.compiler.trampoline.Checkcast;
import org.robovm.compiler.trampoline.FieldAccessor;
import org.robovm.compiler.trampoline.GetField;
import org.robovm.compiler.trampoline.Instanceof;
import org.robovm.compiler.trampoline.Invoke;
import org.robovm.compiler.trampoline.Invokeinterface;
import org.robovm.compiler.trampoline.Invokespecial;
import org.robovm.compiler.trampoline.Invokevirtual;
import org.robovm.compiler.trampoline.LdcClass;
import org.robovm.compiler.trampoline.Multianewarray;
import org.robovm.compiler.trampoline.New;
import org.robovm.compiler.trampoline.PutField;
import org.robovm.compiler.trampoline.Trampoline;
import soot.ClassMember;
import soot.IntType;
import soot.Modifier;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;

public class TrampolineCompiler {
    public static final String ATTEMPT_TO_WRITE_TO_FINAL_FIELD = "Attempt to write to final field %s.%s from class %s";
    public static final String EXPECTED_INTERFACE_BUT_FOUND_CLASS = "Expected interface but found class %s";
    public static final String EXPECTED_NON_STATIC_METHOD = "Expected non-static method %s.%s%s";
    public static final String EXPECTED_STATIC_METHOD = "Expected static method %s.%s%s";
    public static final String EXPECTED_CLASS_BUT_FOUND_INTERFACE = "Expected class but found interface %s";
    public static final String EXPECTED_NON_STATIC_FIELD = "Expected non-static field %s.%s";
    public static final String EXPECTED_STATIC_FIELD = "Expected static field %s.%s";
    public static final String NO_SUCH_FIELD_ERROR = "%s.%s";
    public static final String NO_SUCH_METHOD_ERROR = "%s.%s%s";
    private final Config config;
    private ModuleBuilder mb;

    public TrampolineCompiler(Config config) {
        this.config = config;
    }

    private Linkage aliasLinkage() {
        return this.config.isDebug() ? Linkage.external : Linkage._private;
    }

    private FunctionAttribute shouldInline() {
        return this.config.isDebug() ? FunctionAttribute.noinline : FunctionAttribute.alwaysinline;
    }

    public void compile(ModuleBuilder mb, Clazz currentClass, Trampoline t, Set<String> dependencies, Set<Triple<String, String, String>> methodDependencies) {
        this.mb = mb;
        TrampolineCompiler.addDependencyIfNeeded(dependencies, currentClass, t);
        Function errorFn = new FunctionBuilder(t).linkage(Linkage.external).build();
        if (!this.checkClassExists(errorFn, t) || !this.checkClassAccessible(errorFn, t)) {
            mb.addFunction(errorFn);
            return;
        }
        if (t instanceof New) {
            SootClass target = this.config.getClazzes().load(t.getTarget()).getSootClass();
            if (target.isAbstract() || target.isInterface()) {
                Functions.call(errorFn, (Value)Functions.BC_THROW_INSTANTIATION_ERROR, errorFn.getParameterRef(0), mb.getString(t.getTarget().replace('/', '.')));
                errorFn.add(new Unreachable());
                mb.addFunction(errorFn);
                return;
            }
            String fnName = Symbols.clinitWrapperSymbol(Symbols.allocatorSymbol(t.getTarget()));
            this.alias(t, fnName);
        } else if (t instanceof Instanceof) {
            if (Types.isArray(t.getTarget())) {
                FunctionRef fnRef = this.createInstanceofArray((Instanceof)t);
                this.alias(t, fnRef.getName());
            } else {
                String fnName = Symbols.instanceofSymbol(t.getTarget());
                this.alias(t, fnName);
            }
        } else if (t instanceof Checkcast) {
            if (Types.isArray(t.getTarget())) {
                FunctionRef fnRef = this.createCheckcastArray((Checkcast)t);
                this.alias(t, fnRef.getName());
            } else {
                String fnName = Symbols.checkcastSymbol(t.getTarget());
                this.alias(t, fnName);
            }
        } else if (t instanceof LdcClass) {
            if (Types.isArray(t.getTarget())) {
                FunctionRef fnRef = this.createLdcArray((LdcClass)t);
                this.alias(t, fnRef.getName());
            } else {
                String fnName = Symbols.ldcExternalSymbol(t.getTarget());
                this.alias(t, fnName);
            }
        } else if (t instanceof Anewarray) {
            FunctionRef fnRef = this.createAnewarray((Anewarray)t);
            this.alias(t, fnRef.getName());
        } else if (t instanceof Multianewarray) {
            FunctionRef fnRef = this.createMultianewarray((Multianewarray)t);
            this.alias(t, fnRef.getName());
        } else if (t instanceof FieldAccessor) {
            SootField field = this.resolveField(errorFn, (FieldAccessor)t);
            if (field != null) {
                dependencies.add(Types.getInternalName(field.getDeclaringClass()));
            }
            if (field == null || !this.checkMemberAccessible(errorFn, t, field)) {
                mb.addFunction(errorFn);
                return;
            }
            Clazz caller = this.config.getClazzes().load(t.getCallingClass());
            Clazz target = this.config.getClazzes().load(t.getTarget());
            if (!((FieldAccessor)t).isGetter() && field.isFinal() && caller != target) {
                this.throwIllegalAccessError(errorFn, ATTEMPT_TO_WRITE_TO_FINAL_FIELD, target, field.getName(), caller);
                mb.addFunction(errorFn);
                return;
            }
            if (!field.isStatic()) {
                this.createInlinedAccessorForInstanceField((FieldAccessor)t, field);
            } else {
                this.createTrampolineAliasForField((FieldAccessor)t, field);
            }
        } else if (t instanceof Invokeinterface) {
            SootMethod rm = this.resolveInterfaceMethod(errorFn, (Invokeinterface)t);
            if (rm != null) {
                methodDependencies.add(new ImmutableTriple<String, String, String>(Types.getInternalName(rm.getDeclaringClass()), rm.getName(), Types.getDescriptor(rm)));
            }
            if (rm == null || !this.checkMemberAccessible(errorFn, t, rm)) {
                mb.addFunction(errorFn);
                return;
            }
            this.createTrampolineAliasForMethod((Invoke)t, rm);
        } else if (t instanceof Invoke) {
            SootMethod method = this.resolveMethod(errorFn, (Invoke)t);
            if (method != null) {
                methodDependencies.add(new ImmutableTriple<String, String, String>(Types.getInternalName(method.getDeclaringClass()), method.getName(), Types.getDescriptor(method)));
            }
            if (method == null || !this.checkMemberAccessible(errorFn, t, method)) {
                mb.addFunction(errorFn);
                return;
            }
            if (t instanceof Invokespecial && method.isAbstract()) {
                Functions.call(errorFn, (Value)Functions.BC_THROW_ABSTRACT_METHOD_ERROR, errorFn.getParameterRef(0), mb.getString(String.format(NO_SUCH_METHOD_ERROR, method.getDeclaringClass(), method.getName(), Types.getDescriptor(method))));
                errorFn.add(new Unreachable());
                mb.addFunction(errorFn);
                return;
            }
            this.createTrampolineAliasForMethod((Invoke)t, method);
        }
    }

    private static void addDependencyIfNeeded(Set<String> deps, Clazz clazz, Trampoline t) {
        String desc2 = t.getTarget();
        if (desc2.charAt(0) == 'L' && desc2.endsWith(";") || desc2.charAt(0) == '[') {
            TrampolineCompiler.addDependencyIfNeeded(deps, clazz, desc2);
        } else {
            deps.add(t.getTarget());
        }
    }

    private static void addDependencyIfNeeded(Set<String> deps, Clazz clazz, String desc2) {
        if (desc2.charAt(0) == 'L' || desc2.charAt(0) == '[') {
            if (!(Types.isPrimitive(desc2) || Types.isArray(desc2) && Types.isPrimitiveBaseType(desc2))) {
                String internalName;
                String string = internalName = Types.isArray(desc2) ? Types.getBaseType(desc2) : Types.getInternalNameFromDescriptor(desc2);
                if (!clazz.getInternalName().equals(internalName)) {
                    deps.add(internalName);
                }
            }
        } else {
            deps.add(desc2);
        }
    }

    private void alias(Trampoline t, String fnName) {
        FunctionRef aliasee = new FunctionRef(fnName, t.getFunctionType());
        if (!this.mb.hasSymbol(fnName)) {
            this.mb.addFunctionDeclaration(new FunctionDeclaration(aliasee));
        }
        Function fn = new FunctionBuilder(t).linkage(this.aliasLinkage()).attribs(this.shouldInline(), FunctionAttribute.optsize).build();
        Value result = Functions.call(fn, (Value)aliasee, fn.getParameterRefs());
        fn.add(new Ret(result));
        this.mb.addFunction(fn);
    }

    private void createTrampolineAliasForField(FieldAccessor t, SootField field) {
        String fnName;
        String string = fnName = t.isGetter() ? Symbols.getterSymbol(field) : Symbols.setterSymbol(field);
        if (t.isStatic()) {
            fnName = Symbols.clinitWrapperSymbol(fnName);
        }
        this.alias(t, fnName);
    }

    private void createInlinedAccessorForInstanceField(FieldAccessor t, SootField field) {
        Function fn = new FunctionBuilder(t).linkage(this.aliasLinkage()).attribs(this.shouldInline(), FunctionAttribute.optsize).build();
        List<SootField> classFields = Collections.emptyList();
        StructureType classType = new StructureType(new Type[0]);
        List<SootField> instanceFields = Types.getInstanceFields(this.config.getOs(), this.config.getArch(), field.getDeclaringClass());
        StructureType instanceType = Types.getInstanceType(this.config.getOs(), this.config.getArch(), field.getDeclaringClass());
        if (t.isGetter()) {
            ClassCompiler.createFieldGetter(fn, field, classFields, classType, instanceFields, instanceType);
        } else {
            ClassCompiler.createFieldSetter(fn, field, classFields, classType, instanceFields, instanceType);
        }
        this.mb.addFunction(fn);
    }

    private void createTrampolineAliasForMethod(Invoke t, SootMethod rm) {
        String fnName = null;
        fnName = t instanceof Invokeinterface ? Symbols.lookupWrapperSymbol(rm) : (t instanceof Invokevirtual && !Modifier.isFinal(rm.getDeclaringClass().getModifiers()) && !Modifier.isFinal(rm.getModifiers()) && !Modifier.isPrivate(rm.getModifiers()) ? Symbols.lookupWrapperSymbol(rm) : (rm.isSynchronized() ? Symbols.synchronizedWrapperSymbol(rm) : Symbols.methodSymbol(rm)));
        if (t.isStatic()) {
            fnName = Symbols.clinitWrapperSymbol(fnName);
        }
        this.alias(t, fnName);
    }

    private Value callLdcArray(Function function, String targetClass) {
        FunctionRef fnRef = this.createLdcArray(targetClass);
        return Functions.call(function, (Value)fnRef, function.getParameterRef(0));
    }

    private FunctionRef createLdcArray(LdcClass t) {
        return this.createLdcArray(t.getTarget());
    }

    private FunctionRef createLdcArray(String targetClass) {
        if (Types.isPrimitiveComponentType(targetClass)) {
            throw new IllegalArgumentException();
        }
        String fnName = Symbols.arrayldcSymbol(targetClass);
        FunctionRef fnRef = new FunctionRef(fnName, new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR));
        if (!this.mb.hasSymbol(fnName)) {
            Clazz baseType;
            Function fn = new FunctionBuilder(fnRef).name(fnName).linkage(Linkage.weak).build();
            Global g = new Global(Symbols.arrayPtrSymbol(targetClass), Linkage.weak, new NullConstant(Types.OBJECT_PTR));
            if (!this.mb.hasSymbol(g.getName())) {
                this.mb.addGlobal(g);
            }
            FunctionRef ldcArrayClassFn = Functions.BC_LDC_ARRAY_BOOT_CLASS;
            if (!Types.isPrimitiveBaseType(targetClass) && !(baseType = this.config.getClazzes().load(Types.getBaseType(targetClass))).isInBootClasspath()) {
                ldcArrayClassFn = Functions.BC_LDC_ARRAY_CLASS;
            }
            Value arrayClass = Functions.call(fn, (Value)ldcArrayClassFn, fn.getParameterRef(0), g.ref(), this.mb.getString(targetClass));
            fn.add(new Ret(arrayClass));
            this.mb.addFunction(fn);
        }
        return fnRef;
    }

    private FunctionRef createInstanceofArray(Instanceof t) {
        String fnName = Symbols.arrayinstanceofSymbol(t.getTarget());
        if (!this.mb.hasSymbol(fnName)) {
            Function fn = new FunctionBuilder(t).name(fnName).linkage(Linkage.weak).build();
            Value arrayClass = this.callLdcArray(fn, t.getTarget());
            Value result = Functions.call(fn, (Value)Functions.BC_INSTANCEOF_ARRAY, fn.getParameterRef(0), arrayClass, fn.getParameterRef(1));
            fn.add(new Ret(result));
            this.mb.addFunction(fn);
        }
        return new FunctionRef(fnName, t.getFunctionType());
    }

    private FunctionRef createCheckcastArray(Checkcast t) {
        String fnName = Symbols.arraycheckcastSymbol(t.getTarget());
        if (!this.mb.hasSymbol(fnName)) {
            Function fn = new FunctionBuilder(t).name(fnName).linkage(Linkage.weak).build();
            Value arrayClass = this.callLdcArray(fn, t.getTarget());
            Value result = Functions.call(fn, (Value)Functions.BC_CHECKCAST_ARRAY, fn.getParameterRef(0), arrayClass, fn.getParameterRef(1));
            fn.add(new Ret(result));
            this.mb.addFunction(fn);
        }
        return new FunctionRef(fnName, t.getFunctionType());
    }

    private FunctionRef createAnewarray(Anewarray t) {
        String fnName = Symbols.anewarraySymbol(t.getTarget());
        if (!this.mb.hasSymbol(fnName)) {
            Function fn = new FunctionBuilder(t).name(fnName).linkage(Linkage.weak).build();
            Value arrayClass = this.callLdcArray(fn, t.getTarget());
            Value result = Functions.call(fn, (Value)Functions.BC_NEW_OBJECT_ARRAY, fn.getParameterRef(0), fn.getParameterRef(1), arrayClass);
            fn.add(new Ret(result));
            this.mb.addFunction(fn);
        }
        return new FunctionRef(fnName, t.getFunctionType());
    }

    private FunctionRef createMultianewarray(Multianewarray t) {
        String fnName = Symbols.multianewarraySymbol(t.getTarget());
        if (!this.mb.hasSymbol(fnName)) {
            Function fn = new FunctionBuilder(t).name(fnName).linkage(Linkage.weak).build();
            Value arrayClass = this.callLdcArray(fn, t.getTarget());
            Value result = Functions.call(fn, (Value)Functions.BC_NEW_MULTI_ARRAY, fn.getParameterRef(0), fn.getParameterRef(1), fn.getParameterRef(2), arrayClass);
            fn.add(new Ret(result));
            this.mb.addFunction(fn);
        }
        return new FunctionRef(fnName, t.getFunctionType());
    }

    private boolean checkClassExists(Function f, Trampoline t) {
        Clazz caller;
        Clazz target;
        String targetClassName = t.getTarget();
        if (Types.isArray(targetClassName)) {
            if (Types.isPrimitiveBaseType(targetClassName)) {
                return true;
            }
            targetClassName = Types.getBaseType(targetClassName);
        }
        if ((target = this.config.getClazzes().load(targetClassName)) != null && (!(caller = this.config.getClazzes().load(t.getCallingClass())).isInBootClasspath() || target.isInBootClasspath())) {
            return true;
        }
        Functions.call(f, (Value)Functions.BC_THROW_NO_CLASS_DEF_FOUND_ERROR, f.getParameterRef(0), this.mb.getString(t.getTarget()));
        f.add(new Unreachable());
        return false;
    }

    private boolean checkClassAccessible(Function f, Trampoline t) {
        Clazz target;
        Clazz caller = this.config.getClazzes().load(t.getCallingClass());
        String targetClassName = t.getTarget();
        if (Types.isArray(targetClassName)) {
            if (Types.isPrimitiveBaseType(targetClassName)) {
                return true;
            }
            targetClassName = Types.getBaseType(targetClassName);
        }
        if (Access.checkClassAccessible(target = this.config.getClazzes().load(targetClassName), caller)) {
            return true;
        }
        this.throwIllegalAccessError(f, "Attempt to access class %s from class %s", target, caller);
        f.add(new Unreachable());
        return false;
    }

    private boolean checkMemberAccessible(Function f, Trampoline t, ClassMember member) {
        Clazz caller = this.config.getClazzes().load(t.getCallingClass());
        Clazz target = this.config.getClazzes().load(member.getDeclaringClass().getName().replace('.', '/'));
        String runtimeClassName = null;
        runtimeClassName = t instanceof Invokevirtual ? ((Invokevirtual)t).getRuntimeClass() : runtimeClassName;
        runtimeClassName = t instanceof Invokespecial ? ((Invokespecial)t).getRuntimeClass() : runtimeClassName;
        runtimeClassName = t instanceof GetField ? ((GetField)t).getRuntimeClass() : runtimeClassName;
        runtimeClassName = t instanceof PutField ? ((PutField)t).getRuntimeClass() : runtimeClassName;
        SootClass runtimeClass = null;
        if (runtimeClassName != null && !Types.isArray(runtimeClassName)) {
            Clazz c = this.config.getClazzes().load(runtimeClassName);
            if (c == null) {
                return true;
            }
            runtimeClass = c.getSootClass();
        }
        if (Access.checkMemberAccessible(member, caller, target, runtimeClass)) {
            return true;
        }
        if (member instanceof SootMethod) {
            SootMethod method = (SootMethod)member;
            this.throwIllegalAccessError(f, "Attempt to access method %s.%s%s from class %s", method.getDeclaringClass(), method.getName(), Types.getDescriptor(method), caller.getSootClass());
        } else {
            SootField field = (SootField)member;
            this.throwIllegalAccessError(f, "Attempt to access field %s.%s from class %s", field.getDeclaringClass(), field.getName(), caller.getSootClass());
        }
        f.add(new Unreachable());
        return false;
    }

    private void throwNoSuchMethodError(Function f, Invoke invoke) {
        Functions.call(f, (Value)Functions.BC_THROW_NO_SUCH_METHOD_ERROR, f.getParameterRef(0), this.mb.getString(String.format(NO_SUCH_METHOD_ERROR, invoke.getTarget().replace('/', '.'), invoke.getMethodName(), invoke.getMethodDesc())));
        f.add(new Unreachable());
    }

    private void throwNoSuchFieldError(Function f, FieldAccessor accessor) {
        Functions.call(f, (Value)Functions.BC_THROW_NO_SUCH_FIELD_ERROR, f.getParameterRef(0), this.mb.getString(String.format(NO_SUCH_FIELD_ERROR, accessor.getTarget().replace('/', '.'), accessor.getFieldName())));
        f.add(new Unreachable());
    }

    private void throwIncompatibleChangeError(Function f, String message, Object ... args) {
        Functions.call(f, (Value)Functions.BC_THROW_INCOMPATIBLE_CLASS_CHANGE_ERROR, f.getParameterRef(0), this.mb.getString(String.format(message, args)));
        f.add(new Unreachable());
    }

    private void throwIllegalAccessError(Function f, String message, Object ... args) {
        Functions.call(f, (Value)Functions.BC_THROW_ILLEGAL_ACCESS_ERROR, f.getParameterRef(0), this.mb.getString(String.format(message, args)));
        f.add(new Unreachable());
    }

    private SootField resolveField(Function f, FieldAccessor t) {
        String desc2;
        String name;
        SootClass target = this.config.getClazzes().load(t.getTarget()).getSootClass();
        SootField field = this.resolveField(target, name = t.getFieldName(), desc2 = t.getFieldDesc());
        if (field == null) {
            this.throwNoSuchFieldError(f, t);
            return null;
        }
        if (!field.isStatic() && t.isStatic()) {
            this.throwIncompatibleChangeError(f, EXPECTED_STATIC_FIELD, field.getDeclaringClass(), t.getFieldName());
            return null;
        }
        if (field.isStatic() && !t.isStatic()) {
            this.throwIncompatibleChangeError(f, EXPECTED_NON_STATIC_FIELD, field.getDeclaringClass(), t.getFieldName());
            return null;
        }
        return field;
    }

    private SootField resolveField(SootClass clazz, String name, String desc2) {
        if (clazz != null && !clazz.isPhantom()) {
            SootField field = this.getField(clazz, name, desc2);
            if (field != null) {
                return field;
            }
            for (SootClass interfaze : clazz.getInterfaces()) {
                field = this.resolveField(interfaze, name, desc2);
                if (field == null) continue;
                return field;
            }
            if (!clazz.isInterface() && clazz.hasSuperclass()) {
                return this.resolveField(clazz.getSuperclass(), name, desc2);
            }
        }
        return null;
    }

    private SootMethod resolveMethod(Function f, Invoke t) {
        SootMethod method;
        SootClass target = this.config.getClazzes().load(t.getTarget()).getSootClass();
        String name = t.getMethodName();
        String desc2 = t.getMethodDesc();
        if ("<init>".equals(name) && t instanceof Invokespecial && (method = this.getMethod(target, name, desc2)) != null) {
            return method;
        }
        if ("<clinit>".equals(name) || "<init>".equals(name)) {
            this.throwNoSuchMethodError(f, t);
            return null;
        }
        method = this.resolveMethod(target, name, desc2);
        if (method == null) {
            this.throwNoSuchMethodError(f, t);
            return null;
        }
        if (t.isStatic() && !method.isStatic()) {
            this.throwIncompatibleChangeError(f, EXPECTED_STATIC_METHOD, target, name, desc2);
            return null;
        }
        if (!t.isStatic() && method.isStatic()) {
            this.throwIncompatibleChangeError(f, EXPECTED_NON_STATIC_METHOD, target, name, desc2);
            return null;
        }
        return method;
    }

    private SootMethod resolveMethod(SootClass clazz, String name, String desc2) {
        if (clazz != null && !clazz.isPhantom()) {
            SootClass c;
            SootMethod method = this.getMethod(clazz, name, desc2);
            if (method != null) {
                return method;
            }
            if (name.equals("sizeOf") && Types.isStruct(clazz)) {
                method = new SootMethod("sizeOf", Collections.EMPTY_LIST, IntType.v(), 9);
                method.setDeclaringClass(clazz);
                method.setDeclared(true);
                return method;
            }
            SootClass sootClass = c = !clazz.isInterface() && clazz.hasSuperclass() ? clazz.getSuperclass() : null;
            while (c != null) {
                method = this.getMethod(c, name, desc2);
                if (method != null) {
                    return method;
                }
                c = !c.isInterface() && c.hasSuperclass() ? c.getSuperclass() : null;
            }
            c = clazz;
            while (c != null) {
                for (SootClass interfaze : c.getInterfaces()) {
                    method = this.resolveInterfaceMethod(interfaze, name, desc2);
                    if (method == null) continue;
                    return method;
                }
                c = !c.isInterface() && c.hasSuperclass() ? c.getSuperclass() : null;
            }
        }
        return null;
    }

    private SootMethod resolveInterfaceMethod(Function f, Invokeinterface t) {
        SootClass target = this.config.getClazzes().load(t.getTarget()).getSootClass();
        String name = t.getMethodName();
        String desc2 = t.getMethodDesc();
        if (!target.isInterface()) {
            this.throwIncompatibleChangeError(f, EXPECTED_INTERFACE_BUT_FOUND_CLASS, target);
            return null;
        }
        if ("<clinit>".equals(name) || "<init>".equals(name)) {
            this.throwNoSuchMethodError(f, t);
            return null;
        }
        SootMethod method = this.resolveInterfaceMethod(target, name, desc2);
        if (method == null) {
            SootClass javaLangObject = this.config.getClazzes().load("java/lang/Object").getSootClass();
            method = this.getMethod(javaLangObject, name, desc2);
        }
        if (method == null) {
            this.throwNoSuchMethodError(f, t);
            return null;
        }
        if (method.isStatic()) {
            this.throwIncompatibleChangeError(f, EXPECTED_NON_STATIC_METHOD, target, name, desc2);
            return null;
        }
        return method;
    }

    private SootMethod resolveInterfaceMethod(SootClass clazz, String name, String desc2) {
        if (clazz != null && !clazz.isPhantom()) {
            SootMethod method = this.getMethod(clazz, name, desc2);
            if (method != null) {
                return method;
            }
            for (SootClass interfaze : clazz.getInterfaces()) {
                method = this.resolveInterfaceMethod(interfaze, name, desc2);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    private SootField getField(SootClass clazz, String name, String desc2) {
        for (SootField f : clazz.getFields()) {
            if (!name.equals(f.getName()) || !desc2.equals(Types.getDescriptor(f))) continue;
            return f;
        }
        return null;
    }

    private SootMethod getMethod(SootClass clazz, String name, String desc2) {
        for (SootMethod m : clazz.getMethods()) {
            if (!name.equals(m.getName()) || !desc2.equals(Types.getDescriptor(m))) continue;
            return m;
        }
        return null;
    }
}

