/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import com.mobidevelop.robovm.org.apache.commons.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Version {
    private static String version = null;
    private static String PROPERTIES_RESOURCE = "/META-INF/robovm/version.properties";

    public static String getVersion() {
        if (version != null) {
            return version;
        }
        InputStream is = null;
        try {
            is = Version.class.getResourceAsStream(PROPERTIES_RESOURCE);
            Properties props = new Properties();
            props.load(is);
            String string = version = props.getProperty("version");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    static long toLong(String v) {
        String buildPart = "1";
        long buildType = 700L;
        if (v.endsWith("-SNAPSHOT")) {
            buildPart = "";
            v = v.substring(0, v.indexOf("-SNAPSHOT"));
            buildType = 0L;
        } else if (v.contains("-alpha-")) {
            buildPart = v.substring(v.lastIndexOf(45) + 1);
            v = v.substring(0, v.indexOf("-alpha-"));
            buildType = 100L;
        } else if (v.contains("-beta-")) {
            buildPart = v.substring(v.lastIndexOf(45) + 1);
            v = v.substring(0, v.indexOf("-beta-"));
            buildType = 300L;
        } else if (v.contains("-rc-")) {
            buildPart = v.substring(v.lastIndexOf(45) + 1);
            v = v.substring(0, v.indexOf("-rc-"));
            buildType = 500L;
        }
        String[] parts = v.split("\\.");
        if (parts.length > 3) {
            throw new IllegalArgumentException("Illegal version number: " + v);
        }
        long major = parts.length > 0 ? Long.parseLong(parts[0]) : 0L;
        long minor = parts.length > 1 ? Long.parseLong(parts[1]) : 0L;
        long rev = parts.length > 2 ? Long.parseLong(parts[2]) : 0L;
        long build = buildPart.isEmpty() ? 0L : Long.parseLong(buildPart);
        long result = ((major * 1000L + minor) * 1000L + rev) * 1000L + build + buildType;
        return result;
    }

    public static boolean isOlderThan(String otherVersion) {
        return Version.toLong(Version.getVersion()) < Version.toLong(otherVersion);
    }

    public static void main(String[] args) {
        System.out.println(Version.toLong("1.0.0-alpha-01"));
    }
}

