/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Metadata;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;

public class BasicBlock {
    private final Function function;
    private final Label label;
    private final List<Instruction> instructions = new ArrayList<Instruction>();

    BasicBlock(Function function, Label label) {
        this.function = function;
        this.label = label;
    }

    public BasicBlockRef ref() {
        return new BasicBlockRef(this.function, this.label);
    }

    public String getName() {
        return this.function.getLabel(this);
    }

    public Label getLabel() {
        return this.label;
    }

    public Function getFunction() {
        return this.function;
    }

    public Set<Variable> getWritesTo() {
        HashSet<Variable> result = new HashSet<Variable>();
        for (Instruction i : this.instructions) {
            result.addAll(i.getWritesTo());
        }
        return result;
    }

    public Set<VariableRef> getReadsFrom() {
        HashSet<VariableRef> result = new HashSet<VariableRef>();
        for (Instruction i : this.instructions) {
            result.addAll(i.getReadsFrom());
        }
        return result;
    }

    public void add(Instruction instruction) {
        this.instructions.add(instruction);
        instruction.basicBlock = this;
    }

    public void insertBefore(Instruction before, Instruction instruction) {
        this.instructions.add(this.instructions.indexOf(before), instruction);
        instruction.basicBlock = this;
    }

    public void insertAfter(Instruction after, Instruction instruction) {
        this.instructions.add(this.instructions.indexOf(after) + 1, instruction);
        instruction.basicBlock = this;
    }

    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    public Instruction first() {
        if (this.instructions.isEmpty()) {
            return null;
        }
        return this.instructions.get(0);
    }

    public Instruction last() {
        if (this.instructions.isEmpty()) {
            return null;
        }
        return this.instructions.get(this.instructions.size() - 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(":\n");
        for (Instruction instruction : this.instructions) {
            sb.append("    ");
            sb.append(instruction.toString());
            List<Metadata> metadata = instruction.getMetadata();
            if (!metadata.isEmpty()) {
                for (Metadata md : metadata) {
                    sb.append(", ");
                    sb.append(md.toString());
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

