/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.FloatingPointType;
import org.robovm.compiler.llvm.Type;

public class FloatingPointConstant
extends Constant {
    private final FloatingPointType type;
    private final Object value;

    public FloatingPointConstant(float value) {
        this(new Float(value).floatValue(), Type.FLOAT);
    }

    public FloatingPointConstant(double value) {
        this(new Double(value), Type.DOUBLE);
    }

    public FloatingPointConstant(double value, FloatingPointType type) {
        this.value = new Double(value);
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatingPointConstant other = (FloatingPointConstant)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        if (this.type == Type.FLOAT) {
            float f = ((Number)this.value).floatValue();
            return "bitcast (i32 " + Float.floatToIntBits(f) + " to float)";
        }
        double d = ((Number)this.value).doubleValue();
        return "bitcast (i64 " + Double.doubleToLongBits(d) + " to double)";
    }
}

