/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.robovm.compiler.llvm.BasicBlock;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.Metadata;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;

public abstract class Instruction {
    BasicBlock basicBlock;
    private List<Metadata> metadata;
    private List<Object> attachments;

    public BasicBlock getBasicBlock() {
        return this.basicBlock;
    }

    public Set<Variable> getWritesTo() {
        return Collections.emptySet();
    }

    public Set<VariableRef> getReadsFrom() {
        return Collections.emptySet();
    }

    public List<Metadata> getMetadata() {
        return this.metadata == null ? Collections.emptyList() : this.metadata;
    }

    public Instruction addMetadata(Metadata md) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<Metadata>();
        }
        this.metadata.add(md);
        return this;
    }

    public Instruction attach(Object o) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Object>();
        }
        this.attachments.add(o);
        return this;
    }

    public List<Object> getAttachments() {
        return this.attachments == null ? Collections.emptyList() : this.attachments;
    }

    public <T> T getAttachment(Class<T> cls) {
        for (Object o : this.getAttachments()) {
            if (!cls.isInstance(o)) continue;
            return (T)o;
        }
        return null;
    }

    public Set<BasicBlockRef> getBranchTargets() {
        return Collections.emptySet();
    }
}

