/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.ArrayConstant;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;

public class Landingpad
extends Instruction {
    private final Variable result;
    private final Constant personalityFn;
    private final boolean cleanup;
    private final Clause[] clauses;

    public Landingpad(Variable result, Constant personalityFn, Clause ... clauses) {
        this(result, personalityFn, false, clauses);
    }

    public Landingpad(Variable result, Constant personalityFn, boolean cleanup, Clause ... clauses) {
        this.result = result;
        this.personalityFn = personalityFn;
        this.cleanup = cleanup;
        this.clauses = new Clause[clauses.length];
        System.arraycopy(clauses, 0, this.clauses, 0, clauses.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.result);
        sb.append(" = landingpad ");
        sb.append(this.result.getType());
        sb.append(" personality ");
        sb.append(this.personalityFn.getType());
        sb.append(' ');
        sb.append(this.personalityFn);
        if (this.cleanup) {
            sb.append(" cleanup");
        }
        for (Clause clause : this.clauses) {
            sb.append(' ');
            sb.append(clause);
        }
        return sb.toString();
    }

    public static class Filter
    implements Clause {
        private final ArrayConstant value;

        public Filter(ArrayConstant value) {
            this.value = value;
        }

        public String toString() {
            return "filter " + this.value.getType() + " " + this.value;
        }
    }

    public static class Catch
    implements Clause {
        private final Value value;

        public Catch(Value value) {
            this.value = value;
        }

        public String toString() {
            return "catch " + this.value.getType() + " " + this.value;
        }
    }

    public static interface Clause {
    }
}

