/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.util.HashSet;
import java.util.Set;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.Ordering;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.VariableRef;

public class Store
extends Instruction {
    private final Value value;
    private final Value pointer;
    private final boolean _volatile;
    private final Ordering ordering;
    private final int alignment;

    public Store(Value value, Value pointer) {
        this(value, pointer, false, null, -1);
    }

    public Store(Value value, Value pointer, boolean _volatile) {
        this(value, pointer, _volatile, null, -1);
    }

    public Store(Value value, Value pointer, boolean _volatile, Ordering ordering, int alignment) {
        this.value = value;
        this.pointer = pointer;
        this._volatile = _volatile;
        this.ordering = ordering;
        this.alignment = alignment;
    }

    public Value getValue() {
        return this.value;
    }

    public Value getPointer() {
        return this.pointer;
    }

    @Override
    public Set<VariableRef> getReadsFrom() {
        HashSet<VariableRef> result = new HashSet<VariableRef>();
        if (this.value instanceof VariableRef) {
            result.add((VariableRef)this.value);
        }
        if (this.pointer instanceof VariableRef) {
            result.add((VariableRef)this.pointer);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("store ");
        if (this._volatile) {
            sb.append("volatile ");
        }
        if (this.ordering != null) {
            sb.append("atomic ");
        }
        sb.append(this.value.getType());
        sb.append(" ");
        sb.append(this.value);
        sb.append(", ");
        sb.append(this.pointer.getType());
        sb.append(" ");
        sb.append(this.pointer);
        if (this.ordering != null) {
            sb.append(" ");
            sb.append((Object)this.ordering);
        }
        if (this.alignment > 0) {
            sb.append(", align ");
            sb.append(this.alignment);
        }
        return sb.toString();
    }
}

