/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import com.mobidevelop.robovm.org.apache.commons.io.FileUtils;
import com.mobidevelop.robovm.org.apache.commons.io.IOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.robovm.compiler.clazz.Path;
import org.robovm.compiler.config.AppExtension;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.config.Resource;
import org.robovm.compiler.config.StripArchivesConfig;
import org.robovm.compiler.target.LaunchParameters;
import org.robovm.compiler.target.Launcher;
import org.robovm.compiler.target.Target;
import org.robovm.compiler.util.ToolchainUtil;
import org.simpleframework.xml.Transient;

public abstract class AbstractTarget
implements Target {
    @Transient
    protected Config config;

    protected AbstractTarget() {
    }

    @Override
    public void init(Config config) {
        this.config = config;
    }

    @Override
    public boolean canLaunch() {
        return true;
    }

    @Override
    public void prepareLaunch() throws IOException {
    }

    @Override
    public LaunchParameters createLaunchParameters() {
        return new LaunchParameters();
    }

    @Override
    public String getInstallRelativeArchivePath(Path path) {
        String name = this.config.getArchiveName(path);
        if (path.isInBootClasspath()) {
            return "lib" + File.separator + "boot" + File.separator + name;
        }
        return "lib" + File.separator + name;
    }

    @Override
    public boolean canLaunchInPlace() {
        return true;
    }

    protected List<String> getTargetExportedSymbols() {
        return Collections.emptyList();
    }

    protected List<String> getTargetCcArgs() {
        return Collections.emptyList();
    }

    protected List<String> getTargetLibs() {
        return Collections.emptyList();
    }

    @Override
    public void build(List<File> objectFiles) throws IOException {
        File outFile = new File(this.config.getTmpDir(), this.config.getExecutableName());
        this.config.getLogger().info("Building %s binary %s", this.config.getTarget().getType(), outFile);
        LinkedList<String> ccArgs = new LinkedList<String>();
        LinkedList<String> libs = new LinkedList<String>();
        ccArgs.addAll(this.getTargetCcArgs());
        libs.addAll(this.getTargetLibs());
        String libSuffix = this.config.isUseDebugLibs() ? "-dbg" : "";
        libs.add("-lrobovm-bc" + libSuffix);
        if (this.config.getOs().getFamily() == OS.Family.darwin) {
            libs.add("-force_load");
            libs.add(new File(this.config.getOsArchDepLibDir(), "librobovm-rt" + libSuffix + ".a").getAbsolutePath());
        } else {
            libs.addAll(Arrays.asList("-Wl,--whole-archive", "-lrobovm-rt" + libSuffix, "-Wl,--no-whole-archive"));
        }
        if (this.config.isSkipInstall()) {
            libs.add("-lrobovm-debug" + libSuffix);
        }
        libs.addAll(Arrays.asList("-lrobovm-core" + libSuffix, "-lgc" + libSuffix, "-lpthread", "-ldl", "-lm", "-lz"));
        if (this.config.getOs().getFamily() == OS.Family.linux) {
            libs.add("-lrt");
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin) {
            libs.add("-liconv");
            libs.add("-lsqlite3");
            libs.add("-framework");
            libs.add("Foundation");
        }
        ccArgs.add("-L");
        ccArgs.add(this.config.getOsArchDepLibDir().getAbsolutePath());
        ArrayList<String> exportedSymbols = new ArrayList<String>();
        exportedSymbols.addAll(this.getTargetExportedSymbols());
        exportedSymbols.add("JNI_OnLoad_*");
        exportedSymbols.addAll(this.config.getExportedSymbols());
        if (this.config.getOs().getFamily() == OS.Family.linux) {
            ccArgs.add("-Wl,-rpath=$ORIGIN");
            ccArgs.add("-Wl,--gc-sections");
            if (!exportedSymbols.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("{\n    ");
                sb.append(StringUtils.join(exportedSymbols, ";\n    "));
                sb.append(";\n};\n");
                File file = new File(this.config.getTmpDir(), "exported_symbols");
                FileUtils.writeStringToFile(file, sb.toString());
                ccArgs.add("-Wl,--dynamic-list=" + file.getAbsolutePath());
            }
        } else if (this.config.getOs().getFamily() == OS.Family.darwin) {
            ccArgs.add("-ObjC");
            if (this.config.isSkipInstall()) {
                exportedSymbols.add("catch_exception_raise");
            }
            for (int i = 0; i < exportedSymbols.size(); ++i) {
                exportedSymbols.set(i, "_" + (String)exportedSymbols.get(i));
            }
            if (!this.config.getUnhideSymbols().isEmpty()) {
                ArrayList<String> aliasedSymbols = new ArrayList<String>();
                for (String symbol : this.config.getUnhideSymbols()) {
                    aliasedSymbols.add("_" + symbol + " __unhidden_" + symbol);
                }
                File file = new File(this.config.getTmpDir(), "aliased_symbols");
                FileUtils.writeLines(file, "ASCII", aliasedSymbols);
                ccArgs.add("-Xlinker");
                ccArgs.add("-alias_list");
                ccArgs.add("-Xlinker");
                ccArgs.add(file.getAbsolutePath());
                exportedSymbols.add("__unhidden_*");
            }
            File exportedSymbolsFile = new File(this.config.getTmpDir(), "exported_symbols");
            FileUtils.writeLines(exportedSymbolsFile, "ASCII", exportedSymbols);
            ccArgs.add("-exported_symbols_list");
            ccArgs.add(exportedSymbolsFile.getAbsolutePath());
            ccArgs.add("-Wl,-no_implicit_dylibs");
            ccArgs.add("-Wl,-dead_strip");
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin && !this.config.getFrameworks().isEmpty()) {
            for (String string : this.config.getFrameworks()) {
                libs.add("-framework");
                libs.add(string);
            }
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin && !this.config.getWeakFrameworks().isEmpty()) {
            for (String string : this.config.getWeakFrameworks()) {
                libs.add("-weak_framework");
                libs.add(string);
            }
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin && !this.config.getFrameworkPaths().isEmpty()) {
            for (File file : this.config.getFrameworkPaths()) {
                ccArgs.add("-F" + file.getAbsolutePath());
            }
        }
        if (!this.config.getLibs().isEmpty()) {
            objectFiles = new ArrayList<File>(objectFiles);
            for (Config.Lib lib : this.config.getLibs()) {
                String p = lib.getValue();
                if (p.endsWith(".o")) {
                    objectFiles.add(new File(p));
                    continue;
                }
                if (p.endsWith(".a")) {
                    if (this.config.getOs().getFamily() == OS.Family.darwin) {
                        if (lib.isForce()) {
                            libs.add("-force_load");
                        }
                        libs.add(new File(p).getAbsolutePath());
                        continue;
                    }
                    if (lib.isForce()) {
                        libs.add("-Wl,--whole-archive");
                    }
                    libs.add(new File(p).getAbsolutePath());
                    if (!lib.isForce()) continue;
                    libs.add("-Wl,--no-whole-archive");
                    continue;
                }
                if (p.endsWith(".dylib") || p.endsWith(".so")) {
                    libs.add(new File(p).getAbsolutePath());
                    continue;
                }
                libs.add("-l" + p);
            }
        }
        ccArgs.add("-fPIC");
        if (this.config.getOs() == OS.macosx) {
            if (!this.config.getFrameworks().contains("CoreServices")) {
                libs.add("-framework");
                libs.add("CoreServices");
            }
        } else if (this.config.getOs() == OS.ios && !this.config.getFrameworks().contains("MobileCoreServices")) {
            libs.add("-framework");
            libs.add("MobileCoreServices");
        }
        this.doBuild(outFile, ccArgs, objectFiles, libs);
    }

    protected void doBuild(File outFile, List<String> ccArgs, List<File> objectFiles, List<String> libs) throws IOException {
        ToolchainUtil.link(this.config, ccArgs, objectFiles, libs, outFile);
    }

    protected String getExecutable() {
        return this.config.getExecutableName();
    }

    protected String getBundleId() {
        return this.config.getMainClass() != null ? this.config.getMainClass() : this.config.getExecutableName();
    }

    @Override
    public void buildFat(Map<Arch, File> slices) throws IOException {
        File destFile = new File(this.config.getTmpDir(), this.getExecutable());
        ArrayList<File> files = new ArrayList<File>(slices.values());
        if (slices.size() > 1) {
            if (this.config.getOs() == OS.linux) {
                throw new UnsupportedOperationException("Fat binaries are not supported when building linux binaries");
            }
            this.config.getLogger().info("Building fat binary for archs %s", StringUtils.join(slices.keySet()));
            ToolchainUtil.lipo(this.config, destFile, files);
        } else if (!((File)files.get(0)).equals(destFile)) {
            FileUtils.copyFile((File)files.get(0), destFile);
            destFile.setExecutable(true, false);
        }
    }

    protected void copyResources(File destDir) throws IOException {
        for (Resource res : this.config.getResources()) {
            res.walk(new Resource.Walker(){

                @Override
                public boolean processDir(Resource resource, File dir, File destDir) throws IOException {
                    return AbstractTarget.this.processDir(resource, dir, destDir);
                }

                @Override
                public void processFile(Resource resource, File file, File destDir) throws IOException {
                    AbstractTarget.this.copyFile(resource, file, destDir);
                }
            }, destDir);
        }
    }

    protected void copyDynamicFrameworks(File destDir) throws IOException {
        final HashSet<String> swiftLibraries = new HashSet<String>();
        File frameworksDir = new File(destDir, "Frameworks");
        for (String framework : this.config.getFrameworks()) {
            boolean isCustomFramework = false;
            File frameworkDir = null;
            for (File path : this.config.getFrameworkPaths()) {
                frameworkDir = new File(path, framework + ".framework");
                if (!frameworkDir.exists() || !frameworkDir.isDirectory()) continue;
                isCustomFramework = true;
                break;
            }
            if (!isCustomFramework) continue;
            boolean isDynamicFramework = false;
            for (File file : frameworkDir.listFiles()) {
                if (!file.isFile() || !this.isDynamicLibrary(file)) continue;
                isDynamicFramework = true;
                break;
            }
            if (!isDynamicFramework) continue;
            this.config.getLogger().info("Copying framework %s from %s to %s", framework, frameworkDir, destDir);
            new Resource(frameworkDir).walk(new Resource.Walker(){

                @Override
                public boolean processDir(Resource resource, File dir, File destDir) throws IOException {
                    return !dir.getName().equals("Headers") && !dir.getName().equals("PrivateHeaders") && !dir.getName().equals("Modules") && !dir.getName().equals("Versions") && !dir.getName().equals("Documentation");
                }

                @Override
                public void processFile(Resource resource, File file, File destDir) throws IOException {
                    if (!AbstractTarget.this.isStaticLibrary(file)) {
                        AbstractTarget.this.copyFile(resource, file, destDir);
                        if (AbstractTarget.this.isDynamicLibrary(file)) {
                            if (AbstractTarget.this.config.getOs() == OS.ios && AbstractTarget.this.config.getArch().isArm()) {
                                File libFile = new File(destDir, file.getName());
                                AbstractTarget.this.stripExtraArches(libFile);
                                AbstractTarget.this.stripBitcode(libFile);
                            }
                            String dependencies = ToolchainUtil.otool(file);
                            Pattern swiftLibraryPattern = Pattern.compile("libswift.+\\.dylib");
                            Matcher matcher = swiftLibraryPattern.matcher(dependencies);
                            while (matcher.find()) {
                                String library = dependencies.substring(matcher.start(), matcher.end());
                                swiftLibraries.add(library);
                            }
                        }
                    }
                }
            }, frameworksDir);
        }
        if (!swiftLibraries.isEmpty()) {
            this.copySwiftLibs(swiftLibraries, frameworksDir, true);
        }
    }

    protected void copyAppExtensions(File destDir) throws IOException {
        File pluginsDir = new File(destDir, "PlugIns");
        for (AppExtension extensionVo : this.config.getAppExtensions()) {
            String extension = extensionVo.getName();
            File extensionDir = null;
            for (File path : this.config.getAppExtensionPaths()) {
                File extPath = new File(path, extension + ".appex");
                if (!extPath.exists() || !extPath.isDirectory()) continue;
                extensionDir = extPath;
                break;
            }
            if (extensionDir == null) continue;
            this.config.getLogger().info("Copying app-extension %s from %s to %s", extension, extensionDir, pluginsDir);
            new Resource(extensionDir).walk(new Resource.Walker(){

                @Override
                public boolean processDir(Resource resource, File dir, File destDir) throws IOException {
                    return true;
                }

                @Override
                public void processFile(Resource resource, File file, File destDir) throws IOException {
                    AbstractTarget.this.copyFile(resource, file, destDir);
                    if (AbstractTarget.this.config.getOs() == OS.ios && AbstractTarget.this.config.getArch().isArm() && AbstractTarget.this.isAppExtension(file)) {
                        File libFile = new File(destDir, file.getName());
                        AbstractTarget.this.stripExtraArches(libFile);
                        AbstractTarget.this.stripBitcode(libFile);
                    }
                }
            }, pluginsDir);
            try {
                File infoPlistFile = new File(pluginsDir, extension + ".appex/Info.plist");
                NSDictionary infoPlist = (NSDictionary)PropertyListParser.parse(infoPlistFile);
                String appExBundleId = this.getBundleId() + "." + extension;
                infoPlist.put("CFBundleIdentifier", (Object)appExBundleId);
                PropertyListParser.saveAsXML((NSObject)infoPlist, infoPlistFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read/update bundle id of extension " + extension);
            }
        }
    }

    private boolean isValidSwiftDir(File swiftDir) {
        return new File(swiftDir, "libswiftCore.dylib").exists();
    }

    private File getSwiftDir(String system) throws IOException {
        String[] versions = new String[]{"swift", "swift-5.0"};
        String xcodePath = ToolchainUtil.findXcodePath();
        for (String v : versions) {
            File candidate = new File(xcodePath, "Toolchains/XcodeDefault.xctoolchain/usr/lib/" + v + "/" + system);
            if (!this.isValidSwiftDir(candidate)) continue;
            return candidate;
        }
        throw new IOException("Failed to locate Swift Library directory!");
    }

    protected void copySwiftLibs(Collection<String> swiftLibraries, File targetDir, boolean strip) throws IOException {
        File swiftLibrary;
        String system = null;
        system = this.config.getOs() == OS.ios ? (this.config.getArch().isArm() ? "iphoneos" : "iphonesimulator") : "mac";
        File swiftDir = this.getSwiftDir(system);
        HashSet<String> libsToResolve = new HashSet<String>(swiftLibraries);
        HashSet<String> extendedSwiftLibraries = new HashSet<String>(swiftLibraries);
        while (!libsToResolve.isEmpty()) {
            for (String library : new HashSet<String>(libsToResolve)) {
                libsToResolve.remove(library);
                swiftLibrary = new File(swiftDir, library);
                String dependencies = ToolchainUtil.otool(swiftLibrary);
                Pattern swiftLibraryPattern = Pattern.compile("libswift.+\\.dylib");
                Matcher matcher = swiftLibraryPattern.matcher(dependencies);
                while (matcher.find()) {
                    String lib = dependencies.substring(matcher.start(), matcher.end());
                    if (!extendedSwiftLibraries.add(lib)) continue;
                    libsToResolve.add(lib);
                }
            }
        }
        for (String library : extendedSwiftLibraries) {
            this.config.getLogger().info("Copying swift lib %s from %s to %s", library, swiftDir, targetDir);
            swiftLibrary = new File(swiftDir, library);
            FileUtils.copyFileToDirectory(swiftLibrary, targetDir);
            if (!strip || this.config.getOs() != OS.ios || !this.config.getArch().isArm()) continue;
            File libFile = new File(targetDir, swiftLibrary.getName());
            this.stripExtraArches(libFile);
            this.stripBitcode(libFile);
        }
    }

    protected void stripExtraArches(File libFile) throws IOException {
        String archs = ToolchainUtil.lipoInfo(this.config, libFile);
        ArrayList<String> archesToRemove = new ArrayList<String>();
        if (archs.contains(Arch.x86.getClangName())) {
            archesToRemove.add(Arch.x86.getClangName());
        }
        if (archs.contains(Arch.x86_64.getClangName())) {
            archesToRemove.add(Arch.x86_64.getClangName());
        }
        if (archs.contains("arm64e")) {
            archesToRemove.add("arm64e");
        }
        if (!archesToRemove.isEmpty()) {
            File tmpFile = new File(libFile.getAbsolutePath() + ".tmp");
            ToolchainUtil.lipoRemoveArchs(this.config, libFile, tmpFile, archesToRemove.toArray(new String[0]));
            FileUtils.copyFile(tmpFile, libFile);
            tmpFile.delete();
        }
    }

    protected void stripBitcode(File libFile) throws IOException {
        File tmpFile = new File(libFile.getAbsolutePath() + ".tmp");
        ToolchainUtil.bitcodeStrip(this.config, libFile, tmpFile);
        FileUtils.copyFile(tmpFile, libFile);
        tmpFile.delete();
    }

    protected boolean isDynamicLibrary(File file) throws IOException {
        String result = ToolchainUtil.file(file);
        return result.contains("shared library");
    }

    protected boolean isStaticLibrary(File file) throws IOException {
        String result = ToolchainUtil.file(file);
        return result.contains("ar archive");
    }

    protected boolean isAppExtension(File file) throws IOException {
        String result = ToolchainUtil.file(file);
        return result.contains("Mach-O 64-bit executable") || result.contains("Mach-O executable");
    }

    protected boolean processDir(Resource resource, File dir, File destDir) throws IOException {
        return true;
    }

    protected void copyFile(Resource resource, File file, File destDir) throws IOException {
        this.config.getLogger().info("Copying resource %s to %s", file, destDir);
        FileUtils.copyFileToDirectory(file, destDir, true);
    }

    @Override
    public void install() throws IOException {
        this.config.getLogger().info("Installing %s binary to %s", this.config.getTarget().getType(), this.config.getInstallDir());
        this.config.getInstallDir().mkdirs();
        this.doInstall(this.config.getInstallDir(), this.config.getExecutableName(), this.config.getInstallDir());
    }

    @Override
    public List<Arch> getDefaultArchs() {
        return Collections.emptyList();
    }

    @Override
    public void archive() throws IOException {
        throw new UnsupportedOperationException("Archiving is not supported for this target");
    }

    protected void doInstall(File installDir, String image, File resourcesDir) throws IOException {
        if (!this.config.getTmpDir().equals(installDir) || !image.equals(this.config.getExecutableName())) {
            File destFile = new File(installDir, image);
            FileUtils.copyFile(new File(this.config.getTmpDir(), this.config.getExecutableName()), destFile);
            destFile.setExecutable(true, false);
        }
        for (File f : this.config.getOsArchDepLibDir().listFiles()) {
            if (!f.getName().matches(".*\\.(so|dylib)(\\.1)?")) continue;
            FileUtils.copyFileToDirectory(f, installDir);
        }
        this.stripArchives(installDir);
        this.copyResources(resourcesDir);
        this.copyDynamicFrameworks(installDir);
        this.copyAppExtensions(installDir);
    }

    @Override
    public Process launch(LaunchParameters launchParameters) throws IOException {
        if (this.config.isSkipLinking()) {
            throw new IllegalStateException("Cannot skip linking if target should be run");
        }
        boolean add = true;
        for (String arg : launchParameters.getArguments()) {
            if (!arg.startsWith("-rvm:log=")) continue;
            add = false;
            break;
        }
        if (add) {
            ArrayList<String> args = new ArrayList<String>(launchParameters.getArguments());
            args.add(0, "-rvm:log=warn");
            launchParameters.setArguments(args);
        }
        HashMap<String, String> env = new HashMap<String, String>(launchParameters.getEnvironment() != null ? launchParameters.getEnvironment() : Collections.emptyMap());
        env.put("ROBOVM_LAUNCH_MODE", this.config.isDebug() ? "debug" : "release");
        launchParameters.setEnvironment(env);
        return this.doLaunch(launchParameters);
    }

    protected Process doLaunch(LaunchParameters launchParameters) throws IOException {
        return this.createLauncher(launchParameters).execAsync();
    }

    protected Launcher createLauncher(LaunchParameters launchParameters) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Target build(Config config) {
        return this;
    }

    protected void stripArchives(File installDir) throws IOException {
        ArrayList<Path> allPaths = new ArrayList<Path>();
        allPaths.addAll(this.config.getClazzes().getPaths());
        allPaths.addAll(this.config.getResourcesPaths());
        for (Path path : allPaths) {
            File destJar = new File(installDir, this.getInstallRelativeArchivePath(path));
            if (!destJar.getParentFile().exists()) {
                destJar.getParentFile().mkdirs();
            }
            this.stripArchive(path, destJar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stripArchive(Path path, File output) throws IOException {
        if (!this.config.isClean() && output.exists() && !path.hasChangedSince(output.lastModified())) {
            this.config.getLogger().info("Not creating stripped archive file %s for unchanged path %s", output, path.getFile());
            return;
        }
        this.config.getLogger().info("Creating stripped archive file %s", output);
        ZipOutputStream out = null;
        ArrayList<StripArchivesConfig.Pattern> patterns = this.config.getStripArchivesConfig().getPatterns();
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(output)));
            if (path.getFile().isFile()) {
                ZipFile archive = null;
                try {
                    archive = new ZipFile(path.getFile());
                    Enumeration<? extends ZipEntry> entries = archive.entries();
                    block17: while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (entry.getName().startsWith("META-INF/robovm/")) continue;
                        for (StripArchivesConfig.Pattern pattern : patterns) {
                            if (!pattern.matches(entry.getName())) continue;
                            if (!pattern.isInclude()) continue block17;
                            break;
                        }
                        ZipEntry newEntry = new ZipEntry(entry.getName());
                        newEntry.setTime(entry.getTime());
                        out.putNextEntry(newEntry);
                        InputStream in = null;
                        try {
                            in = archive.getInputStream(entry);
                            IOUtils.copy(in, (OutputStream)out);
                            out.closeEntry();
                        }
                        finally {
                            IOUtils.closeQuietly(in);
                        }
                    }
                }
                finally {
                    try {
                        archive.close();
                    }
                    catch (Throwable entries) {}
                }
            }
            String basePath = path.getFile().getAbsolutePath();
            Collection<File> files = FileUtils.listFiles(path.getFile(), null, true);
            block19: for (File f : files) {
                String entryName = f.getAbsolutePath().substring(basePath.length() + 1);
                if (entryName.startsWith("META-INF/robovm/")) continue;
                for (StripArchivesConfig.Pattern pattern : patterns) {
                    if (!pattern.matches(entryName)) continue;
                    if (!pattern.isInclude()) continue block19;
                    break;
                }
                ZipEntry newEntry = new ZipEntry(entryName);
                newEntry.setTime(f.lastModified());
                out.putNextEntry(newEntry);
                FileInputStream in = null;
                try {
                    in = new FileInputStream(f);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.closeEntry();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly(in);
            }
            IOUtils.closeQuietly(out);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(out);
            output.delete();
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }
}

