/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.exec.util.StringUtils;
import org.robovm.compiler.log.ErrorOutputStream;
import org.robovm.compiler.log.InfoOutputStream;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.target.Launcher;
import org.robovm.compiler.util.AsyncExecutor;
import org.robovm.compiler.util.io.NeverCloseOutputStream;

public class Executor
implements Launcher {
    private final String cmd;
    private final Logger logger;
    private List<String> args = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private boolean inheritEnv = true;
    private File wd;
    private OutputStream out;
    private OutputStream err;
    private InputStream in;
    private boolean closeOutputStreams = false;
    private ExecuteStreamHandler streamHandler = null;

    public Executor(Logger logger, String cmd) {
        this.logger = logger;
        this.cmd = cmd;
    }

    public Executor(Logger logger, File cmd) {
        this.logger = logger;
        this.cmd = cmd.getAbsolutePath();
    }

    public Executor args(Collection<Object> args) {
        if (!args.isEmpty()) {
            return this.args(args.toArray(new Object[args.size()]));
        }
        return this;
    }

    public Executor args(Object ... args) {
        for (Object a : args) {
            if (a instanceof Collection) {
                this.args((Collection)a);
                continue;
            }
            if (a instanceof Object[]) {
                this.args((Object[])a);
                continue;
            }
            this.args.add(a instanceof File ? ((File)a).getAbsolutePath() : a.toString());
        }
        return this;
    }

    public Executor env(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public Executor addEnv(String name, String value) {
        this.env.put(name, value);
        return this;
    }

    public Executor inheritEnv(boolean b) {
        this.inheritEnv = b;
        return this;
    }

    public Executor wd(File wd) {
        this.wd = wd;
        return this;
    }

    public Executor errOut(OutputStream out) {
        this.out = out;
        this.err = out;
        return this;
    }

    public Executor out(OutputStream out) {
        this.out = out;
        return this;
    }

    public Executor err(OutputStream err) {
        this.err = err;
        return this;
    }

    public Executor in(InputStream in) {
        this.in = in;
        return this;
    }

    public Executor streamHandler(ExecuteStreamHandler streamHandler) {
        this.streamHandler = streamHandler;
        return this;
    }

    public Executor closeOutputStreams(boolean b) {
        this.closeOutputStreams = b;
        return this;
    }

    private CommandLine generateCommandLine() {
        CommandLine commandLine = new CommandLine(this.cmd);
        for (String arg : this.args) {
            commandLine.addArgument(arg, false);
        }
        return commandLine;
    }

    private Map<String, String> generateEnv() throws IOException {
        HashMap<String, String> mergedEnv = new HashMap<String, String>();
        if (this.inheritEnv) {
            mergedEnv.putAll(EnvironmentUtils.getProcEnvironment());
        }
        mergedEnv.putAll(this.env);
        return mergedEnv;
    }

    private <T extends org.apache.commons.exec.Executor> T initExecutor(T executor) {
        if (this.streamHandler == null) {
            OutputStream pumpOut = null;
            OutputStream pumpErr = null;
            InputStream pumpIn = null;
            pumpOut = this.out != null ? this.out : new InfoOutputStream(this.logger);
            pumpErr = this.err != null ? this.err : new ErrorOutputStream(this.logger);
            if (this.in != null) {
                pumpIn = this.in;
            }
            if (pumpOut == System.out) {
                pumpOut = new NeverCloseOutputStream(pumpOut);
            }
            if (pumpErr == System.err) {
                pumpErr = new NeverCloseOutputStream(pumpErr);
            }
            executor.setStreamHandler(new PumpStreamHandler(pumpOut, pumpErr, pumpIn){

                @Override
                protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
                    return super.createPump(is, os, Executor.this.closeOutputStreams ? true : closeWhenExhausted);
                }
            });
        } else {
            executor.setStreamHandler(this.streamHandler);
        }
        if (this.wd != null) {
            executor.setWorkingDirectory(this.wd);
        }
        executor.setExitValue(0);
        return executor;
    }

    private void logCommandLine(CommandLine commandLine) {
        if (this.logger == null) {
            return;
        }
        String[] args = commandLine.getArguments();
        if (args.length == 0) {
            this.logger.info(commandLine.toString(), new Object[0]);
            return;
        }
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.quoteArgument(commandLine.getExecutable()));
        result.append(' ');
        boolean first = true;
        for (int i = 0; i < args.length; ++i) {
            String currArgument = args[i];
            if (StringUtils.isQuoted(currArgument)) {
                result.append(currArgument);
            } else {
                result.append(StringUtils.quoteArgument(currArgument));
            }
            if (i < args.length - 1) {
                result.append(' ');
            }
            if (i != args.length - 1 && result.length() <= 2048) continue;
            this.logger.info((first ? "" : "    ") + result.toString(), new Object[0]);
            result.delete(0, result.length());
            first = false;
        }
    }

    public int exec() throws ExecuteException, IOException {
        CommandLine commandLine = this.generateCommandLine();
        this.logCommandLine(commandLine);
        try {
            return this.initExecutor(new DefaultExecutor()).execute(commandLine, this.generateEnv());
        }
        catch (ExecuteException e) {
            ExecuteException ex = new ExecuteException("Command '" + commandLine + "' failed ", e.getExitValue());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    @Override
    public Process execAsync() throws IOException {
        CommandLine commandLine = this.generateCommandLine();
        this.logCommandLine(commandLine);
        return this.initExecutor(new AsyncExecutor()).executeAsync(commandLine, this.generateEnv());
    }

    public String execCapture() throws IOException {
        ExecuteStreamHandler oldStreamHandler = this.streamHandler;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CommandLine commandLine = this.generateCommandLine();
        try {
            this.streamHandler(new PumpStreamHandler(baos, new ErrorOutputStream(this.logger)));
            this.logCommandLine(commandLine);
            DefaultExecutor executor = this.initExecutor(new DefaultExecutor());
            executor.execute(commandLine, this.generateEnv());
            String string = new String(baos.toByteArray()).trim();
            return string;
        }
        catch (ExecuteException e) {
            String output = new String(baos.toByteArray()).trim();
            if (output.length() > 0 && e.getMessage().startsWith("Process exited with an error")) {
                StackTraceElement[] origStackTrace = e.getStackTrace();
                e = new ExecuteException("Command '" + commandLine + "' failed with output: " + output + " ", e.getExitValue());
                e.setStackTrace(origStackTrace);
            }
            throw e;
        }
        finally {
            this.streamHandler = oldStreamHandler;
        }
    }
}

