/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.LaunchPlugin;
import org.robovm.compiler.plugin.PluginArgument;
import org.robovm.compiler.plugin.PluginArguments;
import org.robovm.compiler.target.LaunchParameters;
import org.robovm.compiler.target.Target;
import org.robovm.compiler.target.ios.IOSDeviceLaunchParameters;
import org.robovm.compiler.target.ios.IOSTarget;
import org.robovm.debugger.Debugger;
import org.robovm.debugger.DebuggerConfig;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.hooks.IHooksConnection;
import org.robovm.libimobiledevice.IDeviceConnection;
import org.robovm.libimobiledevice.util.AppLauncherCallback;

public class DebuggerLaunchPlugin
extends LaunchPlugin {
    private static final String ARG_KEY_LOG_CONSOLE = "logconsole";
    private static final String ARG_KEY_SOURCE_PATH = "sourcepath";
    private static final String ARG_KEY_JDWP_PORT = "jdwpport";
    private static final String ARG_KEY_CLIENT_MODE = "clientmode";
    private static final String ARG_KEY_LOG_DIR = "logdir";
    private DebuggerConfig debuggerConfig;
    private Debugger debugger;

    @Override
    public PluginArguments getArguments() {
        ArrayList<PluginArgument> args = new ArrayList<PluginArgument>();
        args.add(new PluginArgument(ARG_KEY_LOG_CONSOLE, "Flag: enables debugger logs to console"));
        args.add(new PluginArgument(ARG_KEY_SOURCE_PATH, "Locations of source files"));
        args.add(new PluginArgument(ARG_KEY_JDWP_PORT, "TCP port JDWP server should listen or connects to"));
        args.add(new PluginArgument(ARG_KEY_CLIENT_MODE, "Flag: specifies that JDWP server shall connect instead of listening"));
        args.add(new PluginArgument(ARG_KEY_LOG_DIR, "Custom location of log directory"));
        return new PluginArguments("debug", args);
    }

    @Override
    public void beforeLaunch(Config config, LaunchParameters parameters) {
        this.cleanup();
        if (!config.isDebug()) {
            return;
        }
        Map<String, String> arguments = this.parseArguments(config);
        String logDir = this.argumentValue(arguments, ARG_KEY_LOG_DIR, config.getTmpDir().getAbsolutePath());
        int jdwpPort = this.argumentIntValue(arguments, ARG_KEY_JDWP_PORT);
        boolean jdwpClientMode = this.argumentValue(arguments, ARG_KEY_CLIENT_MODE, false);
        boolean logConsole = config.isDumpIntermediates() || this.argumentValue(arguments, ARG_KEY_LOG_CONSOLE, false);
        parameters.getArguments().add("-rvm:EnableHooks");
        parameters.getArguments().add("-rvm:WaitForResume");
        Target target = config.getTarget();
        DebuggerConfig.Builder builder = new DebuggerConfig.Builder();
        builder.setJdwpPort(jdwpPort);
        builder.setJdwpClienMode(jdwpClientMode);
        builder.setLogToConsole(logConsole);
        builder.setLogDir(new File(logDir));
        builder.setAppfile(new File(config.isSkipInstall() ? config.getTmpDir() : config.getInstallDir(), config.getExecutableName()));
        builder.setArch(target.getArch());
        if (IOSTarget.isSimulatorArch(target.getArch())) {
            File hooksPortFile;
            try {
                hooksPortFile = File.createTempFile("robovm-dbg-sim", ".port");
                builder.setHooksPortFile(hooksPortFile);
            }
            catch (IOException e) {
                throw new CompilerException("Failed to create simulator debuuger port file", e);
            }
            parameters.getArguments().add("-rvm:PrintDebugPort=" + hooksPortFile.getAbsolutePath());
        } else {
            IOSDeviceLaunchParameters deviceLaunchParameters = (IOSDeviceLaunchParameters)parameters;
            DebuggerLauncherCallback callback = new DebuggerLauncherCallback();
            deviceLaunchParameters.setAppLauncherCallback(callback);
            deviceLaunchParameters.getArguments().add("-rvm:PrintDebugPort");
            builder.setHooksConnection(callback);
        }
        this.debuggerConfig = builder.build();
    }

    @Override
    public void afterLaunch(Config config, LaunchParameters parameters, Process process) {
        if (!config.isDebug()) {
            return;
        }
        this.debugger = new Debugger(process, this.debuggerConfig);
        this.debugger.start();
    }

    @Override
    public void launchFailed(Config config, LaunchParameters parameters) {
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        DebuggerLaunchPlugin debuggerLaunchPlugin = this;
        synchronized (debuggerLaunchPlugin) {
            if (this.debugger != null) {
                this.debugger.shutdown();
            }
            this.debugger = null;
            this.debuggerConfig = null;
        }
    }

    private String argumentValue(Map<String, String> arguments, String key, String defaultValue) {
        String v = arguments.get(key);
        return v != null ? v : defaultValue;
    }

    private int argumentValue(Map<String, String> arguments, String key, int defaultValue) {
        String v = arguments.get(key);
        return v != null ? Integer.parseInt(v) : defaultValue;
    }

    private int argumentIntValue(Map<String, String> arguments, String key) {
        String v = arguments.get(key);
        if (v == null) {
            throw new CompilerException("Missing required debugger argument " + key);
        }
        return Integer.parseInt(v);
    }

    private boolean argumentValue(Map<String, String> arguments, String key, boolean defaultValue) {
        String v = arguments.get(key);
        return v != null ? Boolean.parseBoolean(v) : defaultValue;
    }

    boolean argumentBoolValue(Map<String, String> arguments, String key) {
        String v = arguments.get(key);
        if (v == null) {
            throw new CompilerException("Missing required debugger argument " + key);
        }
        return Boolean.parseBoolean(v);
    }

    private class DebuggerLauncherCallback
    implements AppLauncherCallback,
    IHooksConnection {
        private static final String tag = "[DEBUG] hooks: debugPort=";
        private volatile Integer hooksPort;
        private IDeviceConnection deviceConnection;
        private String incompleteLine;
        private AppLauncherCallback.AppLauncherInfo launchInfo;

        private DebuggerLauncherCallback() {
        }

        @Override
        public void setAppLaunchInfo(AppLauncherCallback.AppLauncherInfo info) {
            this.launchInfo = info;
        }

        @Override
        public byte[] filterOutput(byte[] data) {
            if (this.hooksPort == null) {
                String str = new String(data, Charset.forName("UTF-8"));
                if (this.incompleteLine != null) {
                    str = this.incompleteLine + str;
                    this.incompleteLine = null;
                }
                int lookingPos = 0;
                int newLineIdx = str.indexOf(10);
                while (newLineIdx >= 0) {
                    if (str.startsWith(tag, lookingPos)) {
                        this.hooksPort = Integer.parseInt(str.substring(lookingPos + tag.length(), newLineIdx).trim());
                        break;
                    }
                    lookingPos = newLineIdx + 1;
                    newLineIdx = str.indexOf(10, newLineIdx + 1);
                }
                if (this.hooksPort == null && lookingPos < str.length()) {
                    this.incompleteLine = lookingPos != 0 ? str.substring(lookingPos) : str;
                }
            }
            return data;
        }

        @Override
        public void connect() throws IOException {
            try {
                long ts = System.currentTimeMillis();
                while (this.hooksPort == null) {
                    if (System.currentTimeMillis() - ts > 60000L) {
                        throw new DebuggerException("Timeout while waiting simulator port file");
                    }
                    Thread.sleep(200L);
                }
                this.deviceConnection = this.launchInfo.getDevice().connect(this.hooksPort);
            }
            catch (InterruptedException e) {
                throw new DebuggerException(e);
            }
        }

        @Override
        public void disconnect() throws IOException {
            this.deviceConnection.close();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.deviceConnection.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.deviceConnection.getOutputStream();
        }
    }
}

