/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.delegates;

import java.util.HashSet;
import java.util.Set;
import org.robovm.debugger.delegates.AllDelegates;
import org.robovm.debugger.hooks.unitls.TargetByteBufferReader;
import org.robovm.debugger.state.classdata.MethodInfo;
import org.robovm.debugger.state.instances.VmStackTrace;
import org.robovm.debugger.state.instances.VmThread;

public class RuntimeUtils {
    private final AllDelegates delegates;
    private final long runtimeMemoryOffset;
    private final TargetByteBufferReader deviceMemoryReader;
    private Set<String> activeClassFilters;

    public RuntimeUtils(AllDelegates delegates, long runtimeMemoryOffset) {
        this.delegates = delegates;
        this.runtimeMemoryOffset = runtimeMemoryOffset;
        this.deviceMemoryReader = new TargetByteBufferReader(delegates.hooksApi(), delegates.state().isTarget64bit());
    }

    public long toMachOAddr(long runtimeAddr) {
        return runtimeAddr - this.runtimeMemoryOffset;
    }

    public long toRuntimeAddr(long machOAddr) {
        return machOAddr + this.runtimeMemoryOffset;
    }

    public TargetByteBufferReader deviceMemoryReader() {
        return this.deviceMemoryReader;
    }

    public void setBreakPoint(MethodInfo methodInfo, int line) {
        int lineOffset = line - methodInfo.debugInfo().startLine();
        int addrOffset = lineOffset >> 3;
        int bitOffset = lineOffset & 7;
        int mask = 1 << bitOffset;
        long addr = this.toRuntimeAddr(methodInfo.bpTableAddr() + (long)addrOffset);
        this.delegates.hooksApi().orBits(addr, (byte)(mask & 0xFF));
    }

    public void clearBreakPoint(MethodInfo methodInfo, int line) {
        int lineOffset = line - methodInfo.debugInfo().startLine();
        int addrOffset = lineOffset >> 3;
        int bitOffset = lineOffset & 7;
        int mask = ~(1 << bitOffset);
        long addr = this.toRuntimeAddr(methodInfo.bpTableAddr() + (long)addrOffset);
        this.delegates.hooksApi().andBits(addr, (byte)(mask & 0xFF));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RuntimeStepReference step(VmThread thread, int depth) {
        long pchigh2;
        long pclow2;
        long pchigh;
        long pclow;
        VmStackTrace[] stack = thread.stack();
        VmStackTrace topStackEntry = stack[0];
        if (depth == 0) {
            pclow = 0L;
            pchigh = Long.MAX_VALUE;
            pclow2 = 0L;
            pchigh2 = Long.MAX_VALUE;
        } else {
            VmStackTrace prevStackEntry = null;
            for (int idx = 1; idx < stack.length; ++idx) {
                if (stack[idx].methodInfo().isNative()) continue;
                prevStackEntry = stack[idx];
                break;
            }
            if (depth == 1) {
                pclow = this.toRuntimeAddr(topStackEntry.methodInfo().implPtr());
                pchigh = pclow + (long)topStackEntry.methodInfo().methodCodeSize();
                if (prevStackEntry != null) {
                    pclow2 = this.toRuntimeAddr(prevStackEntry.methodInfo().implPtr());
                    pchigh2 = pclow2 + (long)prevStackEntry.methodInfo().methodCodeSize();
                } else {
                    pclow2 = 0L;
                    pchigh2 = 0L;
                }
            } else {
                if (depth != 2) return null;
                if (prevStackEntry == null) return null;
                pclow = this.toRuntimeAddr(prevStackEntry.methodInfo().implPtr());
                pchigh = pclow + (long)prevStackEntry.methodInfo().methodCodeSize();
                pclow2 = 0L;
                pchigh2 = 0L;
            }
        }
        this.delegates.hooksApi().threadStep(thread.threadPtr(), pclow, pchigh, pclow2, pchigh2);
        return new RuntimeStepReference(thread, pclow, pchigh, pclow2, pchigh2);
    }

    public void restep(RuntimeStepReference ref) {
        this.delegates.hooksApi().threadStep(ref.thread.threadPtr(), ref.pclow, ref.pchigh, ref.pclow2, ref.pchigh2);
    }

    public void setClassLoadFilter(Set<String> filters) {
        Set<String> filtersToSet = null;
        Set<String> filtersToRemove = null;
        if (this.activeClassFilters == null || this.activeClassFilters.isEmpty()) {
            if (filters == null || filters.isEmpty()) {
                return;
            }
            filtersToSet = filters;
        } else if (filters == null || filters.isEmpty()) {
            filtersToRemove = this.activeClassFilters;
        } else {
            filtersToSet = new HashSet<String>(filters);
            filtersToSet.removeAll(this.activeClassFilters);
            filtersToRemove = new HashSet<String>(this.activeClassFilters);
            filtersToRemove.removeAll(filters);
        }
        if (filtersToRemove != null && !filtersToRemove.isEmpty()) {
            for (String className : filtersToRemove) {
                this.delegates.hooksApi().classFilter(false, className);
            }
        }
        if (filtersToSet != null && !filtersToSet.isEmpty()) {
            for (String className : filtersToSet) {
                this.delegates.hooksApi().classFilter(true, className);
            }
        }
        this.activeClassFilters = filters;
    }

    public static class RuntimeStepReference {
        private final VmThread thread;
        private final long pclow;
        private final long pchigh;
        private final long pclow2;
        private final long pchigh2;
        private Object payload;

        private RuntimeStepReference(VmThread thread, long pclow, long pchigh, long pclow2, long pchigh2) {
            this.thread = thread;
            this.pclow = pclow;
            this.pchigh = pchigh;
            this.pclow2 = pclow2;
            this.pchigh2 = pchigh2;
        }

        public VmThread thread() {
            return this.thread;
        }

        public <T> T payload() {
            return (T)this.payload;
        }

        public RuntimeStepReference setPayload(Object payload) {
            this.payload = payload;
            return this;
        }
    }
}

