/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.delegates;

import java.util.HashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.robovm.compiler.plugin.debug.DebuggerDebugMethodInfo;
import org.robovm.compiler.plugin.debug.DebuggerDebugVariableInfo;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.delegates.AllDelegates;
import org.robovm.debugger.jdwp.handlers.stackframe.IJdwpStackFrameDelegate;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoLoader;
import org.robovm.debugger.state.classdata.RuntimeClassInfoLoader;
import org.robovm.debugger.state.instances.VmStackTrace;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;
import org.robovm.llvm.debuginfo.DwarfDebugVariableInfo;

public class StackFrameDelegate
implements IJdwpStackFrameDelegate {
    private final AllDelegates delegates;

    public StackFrameDelegate(AllDelegates delegates) {
        this.delegates = delegates;
    }

    @Override
    public void getFrameValues(long threadId, long frameId, int[] varIndexes, byte[] varTags, ByteBufferPacket output) {
        DebuggerDebugVariableInfo[] variables;
        VmDebuggerState state = this.delegates.state();
        VmThread thread = (VmThread)state.referenceRefIdHolder().instanceById(threadId);
        if (thread == null) {
            throw new DebuggerException(10);
        }
        VmStackTrace frame = state.frameRefIdHolder().objectById(frameId);
        if (frame == null) {
            throw new DebuggerException(30);
        }
        DebuggerDebugMethodInfo debugInfo = frame.methodInfo().debugInfo();
        if (debugInfo == null) {
            throw new DebuggerException(113);
        }
        if (frame.pcoffset() < 0L || frame.pcoffset() > Integer.MAX_VALUE) {
            throw new DebuggerException(113);
        }
        Pair<DebuggerDebugVariableInfo[], DwarfDebugVariableInfo[]> variablesAllocas = debugInfo.getVisibleVariables((int)frame.pcoffset());
        HashMap<DebuggerDebugVariableInfo, DwarfDebugVariableInfo> variableToAlloca = new HashMap<DebuggerDebugVariableInfo, DwarfDebugVariableInfo>();
        if (variablesAllocas != null) {
            variables = variablesAllocas.getLeft();
            DwarfDebugVariableInfo[] allocas = variablesAllocas.getRight();
            for (int idx = 0; idx < variables.length; ++idx) {
                variableToAlloca.put(variables[idx], allocas[idx]);
            }
        }
        variables = debugInfo.localvariables();
        ClassInfo[] classinfos = new ClassInfo[variables.length];
        int stackLineNumber = frame.lineNumber();
        RuntimeClassInfoLoader loader = this.delegates.instances().classInfoLoader();
        for (int idx : varIndexes) {
            if (idx >= variables.length || stackLineNumber < variables[idx].startLine() || stackLineNumber > variables[idx].finalLine()) {
                throw new DebuggerException(35);
            }
            classinfos[idx] = loader.loader().classInfoBySignature(variables[idx].typeSignature());
            if (classinfos[idx] != null || ClassInfoLoader.isArraySignature(variables[idx].typeSignature())) continue;
            if (ClassInfoLoader.isPrimitiveSignature(variables[idx].typeSignature())) {
                classinfos[idx] = loader.buildPrimitiveClassInfo(variables[idx].typeSignature());
            }
            if (classinfos[idx] != null && classinfos[idx].clazzPtr() != 0L) continue;
            throw new DebuggerException(22);
        }
        output.writeInt32(varIndexes.length);
        for (int idx : varIndexes) {
            DwarfDebugVariableInfo alloca = (DwarfDebugVariableInfo)variableToAlloca.get(variables[idx]);
            if (alloca != null) {
                long addr = this.getVariableAddress(frame, alloca);
                this.delegates.instances().getMemoryValue(addr, classinfos[idx], output);
                continue;
            }
            this.delegates.instances().getDefaultValue(classinfos[idx], output);
        }
    }

    @Override
    public void getFrameVariable(long threadId, long frameId, String variableName, ByteBufferPacket output) {
        VmDebuggerState state = this.delegates.state();
        VmThread thread = (VmThread)state.referenceRefIdHolder().instanceById(threadId);
        if (thread == null) {
            throw new DebuggerException(10);
        }
        VmStackTrace frame = state.frameRefIdHolder().objectById(frameId);
        if (frame == null) {
            throw new DebuggerException(30);
        }
        DebuggerDebugMethodInfo debugInfo = frame.methodInfo().debugInfo();
        if (debugInfo == null) {
            throw new DebuggerException(113);
        }
        if (frame.pcoffset() < 0L || frame.pcoffset() > Integer.MAX_VALUE) {
            throw new DebuggerException(113);
        }
        Pair<DebuggerDebugVariableInfo[], DwarfDebugVariableInfo[]> variablesAllocas = debugInfo.getVisibleVariables((int)frame.pcoffset());
        if (variablesAllocas == null) {
            throw new DebuggerException(113);
        }
        DebuggerDebugVariableInfo[] variables = variablesAllocas.getLeft();
        DwarfDebugVariableInfo[] allocas = variablesAllocas.getRight();
        int varIdx = -1;
        for (int idx = 0; idx < variables.length; ++idx) {
            if (!variables[idx].name().equals(variableName)) continue;
            varIdx = idx;
            break;
        }
        if (varIdx != -1) {
            DebuggerDebugVariableInfo variable = variables[varIdx];
            DwarfDebugVariableInfo alloca = allocas[varIdx];
            ClassInfo ci = state.classInfoLoader().classInfoBySignature(variable.typeSignature());
            if (ci == null || ci.clazzPtr() == 0L) {
                throw new DebuggerException(22);
            }
            long addr = this.getVariableAddress(frame, alloca);
            this.delegates.instances().getMemoryValue(addr, ci, output);
        } else {
            output.writeByte((byte)76);
            output.writeLong(0L);
        }
    }

    @Override
    public void setFrameValues(long threadId, long frameId, ByteBufferPacket fromJdpw, int count) {
        DebuggerDebugVariableInfo[] variables;
        VmDebuggerState state = this.delegates.state();
        VmThread thread = (VmThread)state.referenceRefIdHolder().instanceById(threadId);
        if (thread == null) {
            throw new DebuggerException(10);
        }
        VmStackTrace frame = state.frameRefIdHolder().objectById(frameId);
        if (frame == null) {
            throw new DebuggerException(30);
        }
        DebuggerDebugMethodInfo debugInfo = frame.methodInfo().debugInfo();
        if (debugInfo == null) {
            throw new DebuggerException(113);
        }
        if (frame.pcoffset() < 0L || frame.pcoffset() > Integer.MAX_VALUE) {
            throw new DebuggerException(113);
        }
        Pair<DebuggerDebugVariableInfo[], DwarfDebugVariableInfo[]> variablesAllocas = debugInfo.getVisibleVariables((int)frame.pcoffset());
        HashMap<DebuggerDebugVariableInfo, DwarfDebugVariableInfo> variableToAlloca = new HashMap<DebuggerDebugVariableInfo, DwarfDebugVariableInfo>();
        if (variablesAllocas != null) {
            variables = variablesAllocas.getLeft();
            DwarfDebugVariableInfo[] allocas = variablesAllocas.getRight();
            for (int idx = 0; idx < variables.length; ++idx) {
                variableToAlloca.put(variables[idx], allocas[idx]);
            }
        }
        variables = debugInfo.localvariables();
        int stackLineNumber = frame.lineNumber();
        RuntimeClassInfoLoader loader = this.delegates.instances().classInfoLoader();
        while (count > 0) {
            DwarfDebugVariableInfo alloca;
            --count;
            int idx = fromJdpw.readInt32();
            if (idx >= variables.length || stackLineNumber < variables[idx].startLine() || stackLineNumber > variables[idx].finalLine()) {
                throw new DebuggerException(35);
            }
            ClassInfo ci = loader.loader().classInfoBySignature(variables[idx].typeSignature());
            if (ci == null && !ClassInfoLoader.isArraySignature(variables[idx].typeSignature())) {
                if (ClassInfoLoader.isPrimitiveSignature(variables[idx].typeSignature())) {
                    ci = loader.buildPrimitiveClassInfo(variables[idx].typeSignature());
                }
                if (ci == null || ci.clazzPtr() == 0L) {
                    throw new DebuggerException(22);
                }
            }
            if ((alloca = (DwarfDebugVariableInfo)variableToAlloca.get(variables[idx])) != null) {
                long addr = this.getVariableAddress(frame, alloca);
                byte tag = fromJdpw.readByte();
                this.delegates.instances().setMemoryValue(addr, ci, null, fromJdpw);
                continue;
            }
            throw new Error("FIXME: unable to locate alloca for variable " + variables[idx]);
        }
    }

    private long getVariableAddress(VmStackTrace frame, DwarfDebugVariableInfo variableInfo) {
        long addr;
        if (variableInfo.register() == 145) {
            addr = frame.fp() + (long)variableInfo.offset();
        } else if (variableInfo.register() == 143 || variableInfo.register() == 125) {
            addr = frame.fp() - (long)frame.methodInfo().spFpOffset() & (long)(~(frame.methodInfo().spFpAlign() - 1));
            addr += (long)variableInfo.offset();
        } else {
            throw new DebuggerException("Unexpected register for stack trace variable " + DwarfDebugVariableInfo.registerName(variableInfo.register()));
        }
        return addr;
    }
}

