/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.hooks;

public final class HookConsts {
    public static String commandToString(int cmd) {
        switch (cmd) {
            case 1: {
                return "READ_MEMORY";
            }
            case 2: {
                return "READ_CSTRING";
            }
            case 3: {
                return "WRITE_MEMORY";
            }
            case 4: {
                return "WRITE_AND_BITS";
            }
            case 5: {
                return "WRITE_OR_BITS";
            }
            case 6: {
                return "ALLOCATE";
            }
            case 7: {
                return "FREE";
            }
            case 50: {
                return "THREAD_SUSPEND";
            }
            case 51: {
                return "THREAD_RESUME";
            }
            case 52: {
                return "THREAD_STEP";
            }
            case 53: {
                return "THREAD_INVOKE";
            }
            case 54: {
                return "THREAD_NEWSTRING";
            }
            case 55: {
                return "THREAD_NEWARRAY";
            }
            case 56: {
                return "THREAD_NEWINSTANCE";
            }
            case 70: {
                return "CLASS_FILTER";
            }
            case 100: {
                return "THREAD_ATTACHED";
            }
            case 101: {
                return "THREAD_STARTED";
            }
            case 102: {
                return "THREAD_DETTACHED";
            }
            case 103: {
                return "THREAD_SUSPENDED";
            }
            case 104: {
                return "THREAD_RESUMED";
            }
            case 105: {
                return "BREAKPOINT";
            }
            case 106: {
                return "THREAD_STEPPED";
            }
            case 107: {
                return "CLASS_LOAD";
            }
            case 108: {
                return "EXCEPTION";
            }
        }
        return "UNKNOWN_" + cmd;
    }

    public static final class events {
        public static final byte THREAD_ATTACHED = 100;
        public static final byte THREAD_STARTED = 101;
        public static final byte THREAD_DETTACHED = 102;
        public static final byte THREAD_SUSPENDED = 103;
        public static final byte THREAD_RESUMED = 104;
        public static final byte BREAKPOINT = 105;
        public static final byte THREAD_STEPPED = 106;
        public static final byte CLASS_LOAD = 107;
        public static final byte EXCEPTION = 108;
    }

    static final class commands {
        static final byte READ_MEMORY = 1;
        static final byte READ_CSTRING = 2;
        static final byte WRITE_MEMORY = 3;
        static final byte WRITE_AND_BITS = 4;
        static final byte WRITE_OR_BITS = 5;
        static final byte ALLOCATE = 6;
        static final byte FREE = 7;
        static final byte THREAD_SUSPEND = 50;
        static final byte THREAD_RESUME = 51;
        static final byte THREAD_STEP = 52;
        static final byte THREAD_INVOKE = 53;
        static final byte THREAD_NEWSTRING = 54;
        static final byte THREAD_NEWARRAY = 55;
        static final byte THREAD_NEWINSTANCE = 56;
        static final byte CLASS_FILTER = 70;

        commands() {
        }
    }

    static final class handshake {
        static final long QUESTION = 5940074663853768511L;
        static final long ANSWER = 5940074663853760801L;

        handshake() {
        }
    }
}

