/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.delegates.AllDelegates;
import org.robovm.debugger.jdwp.IJdwpServerApi;
import org.robovm.debugger.jdwp.IJdwpServerDelegate;
import org.robovm.debugger.jdwp.handlers.array.JdwpArrayGetLength;
import org.robovm.debugger.jdwp.handlers.array.JdwpArrayGetValues;
import org.robovm.debugger.jdwp.handlers.array.JdwpArraySetValues;
import org.robovm.debugger.jdwp.handlers.arraytype.JdwpArrayTypeNewInstanceHandler;
import org.robovm.debugger.jdwp.handlers.classobjectreference.JdwpClassObjRefReflectedTypeHandler;
import org.robovm.debugger.jdwp.handlers.classtype.JdwpClassTypeInvokeMethodHandler;
import org.robovm.debugger.jdwp.handlers.classtype.JdwpClassTypeNewInstanceHandler;
import org.robovm.debugger.jdwp.handlers.classtype.JdwpClassTypeSetValuesHandler;
import org.robovm.debugger.jdwp.handlers.classtype.JdwpClassTypeSuperclassHandler;
import org.robovm.debugger.jdwp.handlers.eventrequest.JdwpEventReqClearAllBreakpointsHandler;
import org.robovm.debugger.jdwp.handlers.eventrequest.JdwpEventReqClearHandler;
import org.robovm.debugger.jdwp.handlers.eventrequest.JdwpEventReqSetHandler;
import org.robovm.debugger.jdwp.handlers.method.JdwpMethodLineTableHandler;
import org.robovm.debugger.jdwp.handlers.method.JdwpMethodVariableTableHandler;
import org.robovm.debugger.jdwp.handlers.method.JdwpMethodVariableTableWithGenericsHandler;
import org.robovm.debugger.jdwp.handlers.objectreference.JdwpObjRefDisableCollectionHandler;
import org.robovm.debugger.jdwp.handlers.objectreference.JdwpObjRefEnableCollectionHandler;
import org.robovm.debugger.jdwp.handlers.objectreference.JdwpObjRefGetValuesHandler;
import org.robovm.debugger.jdwp.handlers.objectreference.JdwpObjRefInvokeMethodHandler;
import org.robovm.debugger.jdwp.handlers.objectreference.JdwpObjRefIsCollectedHandler;
import org.robovm.debugger.jdwp.handlers.objectreference.JdwpObjRefReferenceTypeHandler;
import org.robovm.debugger.jdwp.handlers.objectreference.JdwpObjRefSetValuesHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeClassFileVersionHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeClassLoaderHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeClassObjectHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeFieldsHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeFieldsWithGenericHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeGetValuesHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeInterfacesHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeMethodsHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeMethodsWithGenericHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeModifiersHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeNestedTypesHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeSignatureHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeSignatureWithGenericHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeSourceFileHandler;
import org.robovm.debugger.jdwp.handlers.referencetype.JdwpRefTypeStatusHandler;
import org.robovm.debugger.jdwp.handlers.stackframe.JdwpStackFrameGetValuesHandler;
import org.robovm.debugger.jdwp.handlers.stackframe.JdwpStackFrameSetValuesHandler;
import org.robovm.debugger.jdwp.handlers.stackframe.JdwpStackFrameThisObjectHandler;
import org.robovm.debugger.jdwp.handlers.string.JdwpStringGetValueHandler;
import org.robovm.debugger.jdwp.handlers.thread.JdwpThreadFramesCountHandler;
import org.robovm.debugger.jdwp.handlers.thread.JdwpThreadFramesHandler;
import org.robovm.debugger.jdwp.handlers.thread.JdwpThreadGetNameHandler;
import org.robovm.debugger.jdwp.handlers.thread.JdwpThreadResumeHandler;
import org.robovm.debugger.jdwp.handlers.thread.JdwpThreadStatusHandler;
import org.robovm.debugger.jdwp.handlers.thread.JdwpThreadSuspendCountHandler;
import org.robovm.debugger.jdwp.handlers.thread.JdwpThreadSuspendHandler;
import org.robovm.debugger.jdwp.handlers.thread.JdwpThreadThreadGroupHandler;
import org.robovm.debugger.jdwp.handlers.threadgroup.JdwpThreadGroupChildrenHandler;
import org.robovm.debugger.jdwp.handlers.threadgroup.JdwpThreadGroupNameHandler;
import org.robovm.debugger.jdwp.handlers.threadgroup.JdwpThreadGroupParentHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmAllClassesHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmAllClassesWithGenericsHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmAllThreadsHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmCapabilitiesHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmCapabilitiesNewHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmClassPathsHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmClassesBySignatureHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmCreateStringHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmDisposeHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmExitHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmHoldEventsHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmIdSizesHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmReleaseEventsHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmResumeHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmSuspendHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmTopLevelThreadGroupsHandler;
import org.robovm.debugger.jdwp.handlers.vm.JdwpVmVersionHandler;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.jdwp.protocol.JdwpRequestHeader;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.utils.DbgLogger;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpDebugServer
implements IJdwpServerApi {
    private final DbgLogger log = DbgLogger.get(this.getClass().getSimpleName());
    private static final String JDWP_HANDSHAKE = "JDWP-Handshake";
    private final Thread socketThread;
    private final boolean jdwpClientMode;
    private final int jdwpPort;
    private Socket socket;
    private Map<Integer, IJdwpRequestHandler> handlers = new HashMap<Integer, IJdwpRequestHandler>();
    private ByteBufferPacket headerBuffer = new ByteBufferPacket();
    private final IJdwpServerDelegate delegate;
    private final AllDelegates delegates;
    private int eventRequestSerial = 0x10000000;

    public JdwpDebugServer(AllDelegates delegates, IJdwpServerDelegate delegate, boolean jdwpClienMode, int jdwpPort) {
        this.delegates = delegates;
        this.delegate = delegate;
        this.jdwpClientMode = jdwpClienMode;
        this.jdwpPort = jdwpPort;
        this.socketThread = delegates.createThread(() -> this.doSocketWork(), "JDWP server socket thread");
        this.headerBuffer = new ByteBufferPacket();
        this.headerBuffer.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public void start() {
        this.registerHandlers();
        this.socketThread.start();
    }

    public void shutdown() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void doSocketWork() {
        try {
            this.socket = this.establishConnection();
            if (this.socket == null) {
                return;
            }
            InputStream inputStream = this.socket.getInputStream();
            JdwpRequestHeader header = new JdwpRequestHeader();
            ByteBufferPacket packet = new ByteBufferPacket();
            ByteBufferPacket outPacket = new ByteBufferPacket();
            packet.setByteOrder(ByteOrder.BIG_ENDIAN);
            packet.fillFromInputStream(inputStream, JDWP_HANDSHAKE.length());
            packet.setPosition(0);
            String handshake2 = packet.readString();
            if (!JDWP_HANDSHAKE.equals(handshake2)) {
                throw new DebuggerException("Unexpected JDWP handshake");
            }
            packet.dumpToOutputStream(this.socket.getOutputStream());
            this.delegate.onJdwpHandshakeComplete(this);
            while (!Thread.interrupted()) {
                short errorCode;
                header.readFromStream(inputStream, packet);
                packet.reset();
                if (header.payloadSize() != 0) {
                    packet.fillFromInputStream(inputStream, header.payloadSize());
                }
                IJdwpRequestHandler handler = this.handlers.get(this.makeHandlerKey(header.commandset, header.command));
                outPacket.reset();
                if (handler != null) {
                    this.log.debug("handling req: " + handler.toString());
                    errorCode = handler.handle(packet, outPacket);
                } else {
                    this.log.debug("unhanndled req: cmdset " + header.commandset + ", cmd " + header.command);
                    errorCode = 99;
                }
                this.sendResponse(header.id, errorCode, outPacket);
                if (errorCode != 112) continue;
                throw new DebuggerException("Terminating due exit command");
            }
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(int id, short errorCode, ByteBufferPacket payload) throws IOException {
        Socket socket = this.socket;
        synchronized (socket) {
            this.headerBuffer.reset();
            this.headerBuffer.writeInt32(11 + payload.size());
            this.headerBuffer.writeInt32(id);
            this.headerBuffer.writeByte((byte)-128);
            this.headerBuffer.writeInt16(errorCode);
            this.headerBuffer.dumpToOutputStream(this.socket.getOutputStream());
            payload.dumpToOutputStream(this.socket.getOutputStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendEvent(byte suspendPolicy, int eventsCount, ByteBufferPacket payload) {
        Socket socket = this.socket;
        synchronized (socket) {
            this.headerBuffer.reset();
            this.headerBuffer.writeInt32(16 + payload.size());
            this.headerBuffer.writeInt32(this.eventRequestSerial++);
            this.headerBuffer.writeByte((byte)0);
            this.headerBuffer.writeByte((byte)64);
            this.headerBuffer.writeByte((byte)100);
            this.headerBuffer.writeByte(suspendPolicy);
            this.headerBuffer.writeInt32(eventsCount);
            try {
                this.headerBuffer.dumpToOutputStream(this.socket.getOutputStream());
                payload.dumpToOutputStream(this.socket.getOutputStream());
            }
            catch (IOException e) {
                throw new DebuggerException(e);
            }
        }
    }

    private Socket establishConnection() throws DebuggerException {
        Socket s = null;
        if (this.jdwpClientMode) {
            while (!Thread.interrupted()) {
                try {
                    s = new Socket();
                    s.connect(new InetSocketAddress("127.0.0.1", this.jdwpPort), 200);
                    break;
                }
                catch (IOException e) {
                    s = null;
                }
            }
        } else {
            ServerSocket serverSocket;
            try {
                serverSocket = new ServerSocket(this.jdwpPort);
            }
            catch (IOException e) {
                throw new DebuggerException("Unable to bind JDWP port " + this.jdwpPort, e);
            }
            try {
                serverSocket.setSoTimeout(200);
            }
            catch (SocketException e) {
                throw new DebuggerException("Failed setup server socket connection", e);
            }
            while (!Thread.interrupted()) {
                try {
                    s = serverSocket.accept();
                    break;
                }
                catch (IOException iOException) {
                }
            }
        }
        if (s == null) {
            this.log.debug("Interrupted while establishing JDWP connection");
        }
        return s;
    }

    private Integer makeHandlerKey(byte commandset, byte command) {
        return commandset * 256 + command;
    }

    private void registerHandler(IJdwpRequestHandler handler) {
        Integer key = this.makeHandlerKey(handler.getCommandSet(), handler.getCommand());
        if (this.handlers.containsKey(key)) {
            throw new RuntimeException("Internal error: specified JDWP handler key already registered");
        }
        this.handlers.put(key, handler);
    }

    private void registerHandlers() {
        VmDebuggerState state = this.delegates.state();
        this.registerHandler(new JdwpVmVersionHandler());
        this.registerHandler(new JdwpVmClassesBySignatureHandler(state));
        this.registerHandler(new JdwpVmAllClassesHandler(state));
        this.registerHandler(new JdwpVmAllThreadsHandler(state));
        this.registerHandler(new JdwpVmTopLevelThreadGroupsHandler(state));
        this.registerHandler(new JdwpVmDisposeHandler());
        this.registerHandler(new JdwpVmIdSizesHandler());
        this.registerHandler(new JdwpVmSuspendHandler(this.delegates));
        this.registerHandler(new JdwpVmResumeHandler(this.delegates));
        this.registerHandler(new JdwpVmExitHandler());
        this.registerHandler(new JdwpVmCreateStringHandler(this.delegates));
        this.registerHandler(new JdwpVmCapabilitiesHandler());
        this.registerHandler(new JdwpVmClassPathsHandler());
        this.registerHandler(new JdwpVmHoldEventsHandler(this.delegates));
        this.registerHandler(new JdwpVmReleaseEventsHandler(this.delegates));
        this.registerHandler(new JdwpVmCapabilitiesNewHandler());
        this.registerHandler(new JdwpVmAllClassesWithGenericsHandler(state));
        this.registerHandler(new JdwpRefTypeSignatureHandler(state));
        this.registerHandler(new JdwpRefTypeClassLoaderHandler());
        this.registerHandler(new JdwpRefTypeModifiersHandler(state));
        this.registerHandler(new JdwpRefTypeFieldsHandler(state));
        this.registerHandler(new JdwpRefTypeMethodsHandler(state));
        this.registerHandler(new JdwpRefTypeGetValuesHandler(this.delegates));
        this.registerHandler(new JdwpRefTypeSourceFileHandler(state));
        this.registerHandler(new JdwpRefTypeNestedTypesHandler());
        this.registerHandler(new JdwpRefTypeStatusHandler(state));
        this.registerHandler(new JdwpRefTypeInterfacesHandler(state));
        this.registerHandler(new JdwpRefTypeClassObjectHandler(this.delegates));
        this.registerHandler(new JdwpRefTypeSignatureWithGenericHandler(state));
        this.registerHandler(new JdwpRefTypeFieldsWithGenericHandler(state));
        this.registerHandler(new JdwpRefTypeMethodsWithGenericHandler(state));
        this.registerHandler(new JdwpRefTypeClassFileVersionHandler(state));
        this.registerHandler(new JdwpClassTypeSuperclassHandler(state));
        this.registerHandler(new JdwpClassTypeSetValuesHandler(this.delegates));
        this.registerHandler(new JdwpClassTypeInvokeMethodHandler(this.delegates));
        this.registerHandler(new JdwpClassTypeNewInstanceHandler(this.delegates));
        this.registerHandler(new JdwpArrayTypeNewInstanceHandler(this.delegates));
        this.registerHandler(new JdwpMethodLineTableHandler(state));
        this.registerHandler(new JdwpMethodVariableTableHandler(state));
        this.registerHandler(new JdwpMethodVariableTableWithGenericsHandler(state));
        this.registerHandler(new JdwpObjRefReferenceTypeHandler(state));
        this.registerHandler(new JdwpObjRefGetValuesHandler(this.delegates));
        this.registerHandler(new JdwpObjRefSetValuesHandler(this.delegates));
        this.registerHandler(new JdwpObjRefInvokeMethodHandler(this.delegates));
        this.registerHandler(new JdwpObjRefDisableCollectionHandler());
        this.registerHandler(new JdwpObjRefEnableCollectionHandler());
        this.registerHandler(new JdwpObjRefIsCollectedHandler(state));
        this.registerHandler(new JdwpStringGetValueHandler(this.delegates));
        this.registerHandler(new JdwpThreadGetNameHandler(state));
        this.registerHandler(new JdwpThreadSuspendHandler(this.delegates));
        this.registerHandler(new JdwpThreadResumeHandler(this.delegates));
        this.registerHandler(new JdwpThreadStatusHandler(state));
        this.registerHandler(new JdwpThreadThreadGroupHandler(state));
        this.registerHandler(new JdwpThreadFramesHandler(state));
        this.registerHandler(new JdwpThreadFramesCountHandler(state));
        this.registerHandler(new JdwpThreadSuspendCountHandler(state));
        this.registerHandler(new JdwpThreadGroupNameHandler(state));
        this.registerHandler(new JdwpThreadGroupParentHandler(state));
        this.registerHandler(new JdwpThreadGroupChildrenHandler(state));
        this.registerHandler(new JdwpArrayGetLength(this.delegates));
        this.registerHandler(new JdwpArrayGetValues(this.delegates));
        this.registerHandler(new JdwpArraySetValues(this.delegates));
        this.registerHandler(new JdwpEventReqSetHandler(this.delegates));
        this.registerHandler(new JdwpEventReqClearHandler(this.delegates));
        this.registerHandler(new JdwpEventReqClearAllBreakpointsHandler(this.delegates));
        this.registerHandler(new JdwpStackFrameGetValuesHandler(this.delegates));
        this.registerHandler(new JdwpStackFrameSetValuesHandler(this.delegates));
        this.registerHandler(new JdwpStackFrameThisObjectHandler(this.delegates));
        this.registerHandler(new JdwpClassObjRefReflectedTypeHandler(state));
    }
}

