/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.array;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.array.IJdwpArrayDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpArrayGetLength
implements IJdwpRequestHandler {
    private final IJdwpArrayDelegate delegate;

    public JdwpArrayGetLength(IJdwpArrayDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long arrayId = payload.readLong();
        try {
            output.writeInt32(this.delegate.jdwpArrayLength(arrayId));
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 13;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "ArrayReference(13).Length(1)";
    }
}

