/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.array;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.array.IJdwpArrayDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpArrayGetValues
implements IJdwpRequestHandler {
    private final IJdwpArrayDelegate delegate;

    public JdwpArrayGetValues(IJdwpArrayDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long arrayId = payload.readLong();
        int firstIndex = payload.readInt32();
        int length = payload.readInt32();
        output.reset();
        try {
            this.delegate.jdwpArrayGetValue(arrayId, firstIndex, length, output);
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 13;
    }

    @Override
    public byte getCommand() {
        return 2;
    }

    public String toString() {
        return "ArrayReference(13).GetValues(2)";
    }
}

