/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.eventrequest.events;

import org.robovm.debugger.jdwp.handlers.eventrequest.events.JdwpEventData;
import org.robovm.debugger.state.instances.VmInstance;
import org.robovm.debugger.state.instances.VmStackTrace;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpThreadStoppedEventData
extends JdwpEventData {
    private final VmStackTrace location;
    private final VmInstance exception;
    private final boolean caught;
    private final String className;

    public JdwpThreadStoppedEventData(byte eventKind, VmThread thread, VmStackTrace location) {
        super(eventKind, thread);
        this.location = location;
        this.exception = null;
        this.caught = false;
        this.className = this.makeClassName(location.classInfo());
    }

    public JdwpThreadStoppedEventData(byte eventKind, VmThread thread, VmStackTrace location, VmInstance exception, boolean caught) {
        super(eventKind, thread);
        this.location = location;
        this.exception = exception;
        this.caught = caught;
        this.className = this.makeClassName(location.classInfo());
    }

    @Override
    public long getExceptionTypeId() {
        return this.exception.classInfo().refId();
    }

    @Override
    public boolean isExceptionCaught() {
        return this.caught;
    }

    @Override
    public VmStackTrace getStoppeedLocation() {
        return this.location;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    protected void dumpCustomData(ByteBufferPacket packet) {
        packet.writeByte((byte)1);
        packet.writeLong(this.location.classInfo().refId());
        packet.writeLong(this.location.methodInfo().refId());
        packet.writeLong(this.location.lineNumber());
        if (this.exception != null) {
            packet.writeByte((byte)76);
            packet.writeLong(this.exception.refId());
            packet.writeLong(this.location.classInfo().refId());
            packet.writeLong(this.location.methodInfo().refId());
            packet.writeLong(this.location.lineNumber());
        }
    }

    @Override
    public boolean cancelIfNotHandled() {
        return true;
    }
}

