/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.objectreference;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.objectreference.IJdwpInstanceDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpObjRefGetValuesHandler
implements IJdwpRequestHandler {
    private final IJdwpInstanceDelegate delegate;

    public JdwpObjRefGetValuesHandler(IJdwpInstanceDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long objectId = payload.readLong();
        int count = payload.readInt32();
        long[] fields2 = new long[count];
        for (int idx = 0; idx < count; ++idx) {
            fields2[idx] = payload.readLong();
        }
        try {
            output.writeInt32(fields2.length);
            this.delegate.jdwpFieldGetValues(objectId, fields2, this.isStatic(), output);
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    protected boolean isStatic() {
        return false;
    }

    @Override
    public byte getCommandSet() {
        return 9;
    }

    @Override
    public byte getCommand() {
        return 2;
    }

    public String toString() {
        return "ObjectReference(9).GetValues(2)";
    }
}

