/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.objectreference;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpObjRefIsCollectedHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpObjRefIsCollectedHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long objectId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            output.writeBoolean(this.state.referenceRefIdHolder().instanceById(objectId) == null);
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 9;
    }

    @Override
    public byte getCommand() {
        return 9;
    }

    public String toString() {
        return "ObjectReference(9).IsCollected(9)";
    }
}

