/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.referencetype;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.objectreference.IJdwpInstanceDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.instances.VmClassInstance;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpRefTypeClassObjectHandler
implements IJdwpRequestHandler {
    private final IJdwpInstanceDelegate delegate;

    public JdwpRefTypeClassObjectHandler(IJdwpInstanceDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long referenceTypeId = payload.readLong();
        try {
            VmClassInstance clazzInstance = this.delegate.jdwpGetClazzObject(referenceTypeId);
            output.writeLong(clazzInstance.refId());
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 2;
    }

    @Override
    public byte getCommand() {
        return 11;
    }

    public String toString() {
        return "ReferenceType(2).ClassObject(11)";
    }
}

