/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.referencetype;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpRefTypeInterfacesHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpRefTypeInterfacesHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long referenceTypeID = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            ClassInfo classInfo = this.state.classInfoLoader().classInfoByRefId(referenceTypeID);
            if (classInfo == null) {
                return 20;
            }
            if (!classInfo.isClass() && !classInfo.isArray()) {
                return 21;
            }
            ClassInfo[] interfaces = classInfo.interfaces(this.state.classInfoLoader());
            output.writeInt32(interfaces.length);
            for (ClassInfo intf : interfaces) {
                output.writeLong(intf.refId());
            }
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 2;
    }

    @Override
    public byte getCommand() {
        return 10;
    }

    public String toString() {
        return "ReferenceType(2).Interfaces(10)";
    }
}

