/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.thread;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.instances.VmStackTrace;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpThreadFramesCountHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpThreadFramesCountHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long threadId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            VmThread thread;
            try {
                thread = (VmThread)this.state.referenceRefIdHolder().instanceById(threadId);
            }
            catch (ClassCastException e) {
                return 10;
            }
            if (thread == null) {
                return 10;
            }
            if (thread.suspendCount() == 0) {
                return 13;
            }
            VmStackTrace[] stack = thread.stack();
            output.writeInt32(stack != null ? stack.length : 0);
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 11;
    }

    @Override
    public byte getCommand() {
        return 7;
    }

    public String toString() {
        return "ThreadReference(11).FramesCount(7)";
    }
}

