/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.threadgroup;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.instances.VmThreadGroup;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpThreadGroupParentHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpThreadGroupParentHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long threadGroupId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            VmThreadGroup threadGroup;
            try {
                threadGroup = (VmThreadGroup)this.state.referenceRefIdHolder().instanceById(threadGroupId);
            }
            catch (ClassCastException e) {
                return 11;
            }
            if (threadGroup == null) {
                return 11;
            }
            VmThreadGroup parent = threadGroup.parent();
            output.writeLong(parent != null ? parent.refId() : 0L);
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 12;
    }

    @Override
    public byte getCommand() {
        return 2;
    }

    public String toString() {
        return "ThreadGroup(12).Parent(2)";
    }
}

