/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;

public class ByteBufferPacket
extends ByteBufferReader {
    private static final int DEFAULT_CAPACITY = 1024;

    public ByteBufferPacket() {
        this(1024, false);
    }

    public ByteBufferPacket(boolean is64Bit) {
        this(1024, is64Bit);
    }

    public ByteBufferPacket(int capacity, boolean is64Bit) {
        super(ByteBuffer.allocate(capacity), is64Bit);
        this.reset();
    }

    @Override
    public int position() {
        return this.byteBuffer.position();
    }

    @Override
    public int size() {
        return this.byteBuffer.limit();
    }

    @Override
    public void setPosition(int position) {
        this.byteBuffer.position(position);
    }

    @Override
    protected int byteBufferDataStart() {
        return 0;
    }

    @Override
    public void reset() {
        this.byteBuffer.position(0);
        this.byteBuffer.limit(0);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    private void wants(int bytes) {
        long capacity;
        long afterWritePos = this.byteBuffer.position() + bytes;
        if (afterWritePos > (capacity = (long)this.byteBuffer.capacity())) {
            long requiredCap = (afterWritePos + capacity - 1L) / capacity;
            ByteBuffer buffer = ByteBuffer.allocate((int)(requiredCap *= capacity * 2L));
            int oldPosition = this.byteBuffer.position();
            this.byteBuffer.position(0);
            buffer.put(this.byteBuffer);
            buffer.position(oldPosition);
            buffer.limit(this.byteBuffer.limit());
            this.byteBuffer = buffer;
        }
        if (afterWritePos > (long)this.byteBuffer.limit()) {
            this.byteBuffer.limit((int)afterWritePos);
        }
    }

    public ByteBufferPacket writeByte(byte b) {
        this.wants(1);
        this.byteBuffer.put(b);
        return this;
    }

    public ByteBufferPacket writeBoolean(boolean b) {
        this.wants(1);
        this.byteBuffer.put((byte)(b ? 1 : 0));
        return this;
    }

    public ByteBufferPacket writeInt32(int i) {
        this.wants(4);
        this.byteBuffer.putInt(i);
        return this;
    }

    public ByteBufferPacket writeUnsignedInt32(long l) {
        this.wants(4);
        int i = (int)l;
        this.byteBuffer.putInt(i);
        return this;
    }

    public ByteBufferPacket writeInt16(short i) {
        this.wants(2);
        this.byteBuffer.putShort(i);
        return this;
    }

    public ByteBufferPacket writeUnsignedInt16(int i) {
        this.wants(2);
        short s = (short)(i & 0xFFFF);
        this.byteBuffer.putShort(s);
        return this;
    }

    public ByteBufferPacket writeChar16(char c) {
        return this.writeUnsignedInt16(c);
    }

    public ByteBufferPacket writeLong(long l) {
        this.wants(8);
        this.byteBuffer.putLong(l);
        return this;
    }

    public ByteBufferPacket writeFloat(float f) {
        this.wants(4);
        this.byteBuffer.putFloat(f);
        return this;
    }

    public ByteBufferPacket writeDouble(double d) {
        this.wants(8);
        this.byteBuffer.putDouble(d);
        return this;
    }

    public ByteBufferPacket writeString(String s) {
        byte[] bytes = s.getBytes();
        this.wants(bytes.length);
        this.byteBuffer.put(bytes);
        return this;
    }

    public ByteBufferPacket writeStringWithLen(String s) {
        byte[] bytes = s.getBytes();
        this.wants(bytes.length + 4);
        this.byteBuffer.putInt(bytes.length);
        this.byteBuffer.put(bytes);
        return this;
    }

    public void fillFromInputStream(InputStream is) throws IOException {
        this.fillFromInputStream(is, this.byteBuffer.remaining());
    }

    public void fillFromInputStream(InputStream is, int count) throws IOException {
        this.wants(count);
        int offset = 0;
        while (count > 0) {
            int bytesRead = is.read(this.byteBuffer.array(), this.byteBuffer.position() + offset, count);
            if (bytesRead <= 0) {
                throw new BufferOverflowException();
            }
            offset += bytesRead;
            count -= bytesRead;
        }
    }

    public void writeBytes(byte[] bytes) {
        this.wants(bytes.length);
        this.byteBuffer.put(bytes);
    }

    public void writePacket(ByteBufferPacket packet) {
        this.wants(packet.bytesRemaining());
        this.byteBuffer.put(packet.getByteBuffer().array(), packet.byteBufferDataStart(), packet.bytesRemaining());
    }

    public void writePointer(long addr) {
        if (this.is64bit) {
            this.writeLong(addr);
        } else {
            this.writeUnsignedInt32(addr);
        }
    }
}

