/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.utils.bytebuffer.RangeByteBufferReader;

public abstract class ByteBufferReader {
    protected ByteBuffer byteBuffer;
    protected final boolean is64bit;
    protected final int pointerSize;

    public ByteBufferReader(ByteBuffer byteBuffer, boolean is64bit) {
        this.byteBuffer = byteBuffer;
        this.is64bit = is64bit;
        this.pointerSize = is64bit ? 8 : 4;
    }

    protected ByteBufferReader(ByteBuffer bb) {
        this(bb, false);
    }

    public static ByteBufferReader wrap(ByteBuffer bb) {
        return new RangeByteBufferReader(bb);
    }

    public static ByteBufferReader wrap(byte[] bytes) {
        return new RangeByteBufferReader(ByteBuffer.wrap(bytes));
    }

    public static ByteBufferReader wrap(byte[] bytes, boolean is64bit) {
        return new RangeByteBufferReader(ByteBuffer.wrap(bytes), is64bit);
    }

    public boolean is64bit() {
        return this.is64bit;
    }

    public abstract int position();

    public abstract int size();

    public abstract void setPosition(int var1);

    protected abstract int byteBufferDataStart();

    public abstract void reset();

    public abstract ByteBuffer getByteBuffer();

    public int absolutePosition() {
        return this.byteBufferDataStart() + this.position();
    }

    public void setPosition(long position) {
        this.setPosition((int)position);
    }

    public boolean hasRemaining() {
        return this.position() < this.size();
    }

    public int bytesRemaining() {
        return this.size() - this.position();
    }

    protected void expects(int bytes) {
        if (this.position() + bytes > this.size()) {
            throw new BufferUnderflowException();
        }
    }

    public byte readByte() {
        this.expects(1);
        return this.byteBuffer.get();
    }

    public boolean readBoolean() {
        this.expects(1);
        return this.byteBuffer.get() != 0;
    }

    public int readInt32() {
        this.expects(4);
        return this.byteBuffer.getInt();
    }

    public long readUnsignedInt32() {
        this.expects(4);
        long res = this.byteBuffer.getInt();
        res += 0x100000000L;
        return res &= 0xFFFFFFFFL;
    }

    public short readInt16() {
        this.expects(2);
        return this.byteBuffer.getShort();
    }

    public int readUnsignedInt16() {
        this.expects(2);
        int res = this.byteBuffer.getShort();
        res = (int)((long)res + 65536L);
        return res &= 0xFFFF;
    }

    public char readChar16() {
        return (char)this.readUnsignedInt16();
    }

    public long readLong() {
        this.expects(8);
        return this.byteBuffer.getLong();
    }

    public float readFloat() {
        this.expects(4);
        return this.byteBuffer.getFloat();
    }

    public double readDouble() {
        this.expects(8);
        return this.byteBuffer.getDouble();
    }

    public String readStringZ() {
        this.expects(1);
        StringBuilder sb = new StringBuilder();
        byte b = this.readByte();
        while (b != 0) {
            sb.append((char)b);
            b = this.byteBuffer.get();
        }
        return sb.toString();
    }

    public String readStringZ(int at) {
        int oldPos = this.position();
        this.setPosition(at);
        String s = this.readStringZ();
        this.setPosition(oldPos);
        return s;
    }

    public String readString(int size) {
        this.expects(size);
        try {
            int byteArrayOffs;
            byte[] byteArray;
            int byteBufPos = this.byteBuffer.position();
            if (this.byteBuffer.hasArray()) {
                byteArray = this.byteBuffer.array();
                byteArrayOffs = this.byteBuffer.position();
            } else {
                byteArray = new byte[size];
                byteArrayOffs = 0;
                this.byteBuffer.get(byteArray);
            }
            int strLen = size;
            for (int i = 0; i < size; ++i) {
                if (byteArray[byteArrayOffs + i] != 0) continue;
                strLen = i;
                break;
            }
            String res = new String(byteArray, byteArrayOffs, strLen, "UTF-8");
            this.byteBuffer.position(byteBufPos + size);
            return res;
        }
        catch (UnsupportedEncodingException e) {
            throw new DebuggerException(e);
        }
    }

    public String readString() {
        if (!this.byteBuffer.hasRemaining()) {
            return "";
        }
        return this.readString(this.byteBuffer.remaining());
    }

    public String readStringWithLen() {
        this.expects(4);
        int stringLen = this.byteBuffer.getInt();
        if (stringLen == 0) {
            return "";
        }
        return this.readString(stringLen);
    }

    public long readPointer() {
        return this.readPointer(false);
    }

    public long readPointer(boolean alligned) {
        long allignedAddr;
        long oldAddr;
        if (alligned && (oldAddr = (long)this.position()) != (allignedAddr = oldAddr + (long)this.pointerSize - 1L & (long)(~(this.pointerSize - 1)))) {
            this.setPosition(allignedAddr);
        }
        return this.is64bit ? this.readLong() : this.readUnsignedInt32();
    }

    public int pointerSize() {
        return this.pointerSize;
    }

    public void skip(int bytesToSkip) {
        this.setPosition(this.position() + bytesToSkip);
    }

    public byte[] readBytes() {
        return this.readBytes(this.byteBuffer.remaining());
    }

    public byte[] readBytes(int numBytes) {
        if (numBytes == 0) {
            throw new DebuggerException("Cant read zero number of bytes!");
        }
        this.expects(numBytes);
        return Arrays.copyOfRange(this.byteBuffer.array(), this.byteBuffer.position(), this.byteBuffer.position() + numBytes);
    }

    public void dumpToOutputStream(OutputStream os) throws IOException {
        os.write(this.byteBuffer.array(), this.byteBufferDataStart(), this.size());
    }

    public void setByteOrder(ByteOrder order) {
        this.byteBuffer.order(order);
    }

    public ByteBufferReader sliceAt(int pos, int size) {
        return new RangeByteBufferReader(this, pos, size, this.is64bit);
    }

    public ByteBufferReader slice(int offest, int size) {
        return new RangeByteBufferReader(this, this.position() + offest, size, this.is64bit);
    }

    public ByteBufferReader slice(int size) {
        return new RangeByteBufferReader(this, this.position(), size, this.is64bit);
    }

    public ByteBufferReader slice() {
        return new RangeByteBufferReader(this, this.position(), this.bytesRemaining(), this.is64bit);
    }

    public ByteBuffer sliceToByteBuffer() {
        return this.byteBuffer.slice();
    }
}

