/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.nio.ByteBuffer;
import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;

class RangeByteBufferReader
extends ByteBufferReader {
    private int virtualStart;
    private int virtualLimit;

    public RangeByteBufferReader(ByteBuffer bb) {
        super(bb.duplicate().asReadOnlyBuffer());
        this.byteBuffer.order(bb.order());
        this.virtualStart = 0;
        this.virtualLimit = bb.limit();
    }

    public RangeByteBufferReader(ByteBuffer bb, boolean is64bit) {
        super(bb.duplicate().asReadOnlyBuffer(), is64bit);
        this.byteBuffer.order(bb.order());
        this.virtualStart = 0;
        this.virtualLimit = bb.limit();
    }

    public RangeByteBufferReader(ByteBufferReader other, int offs, int size, boolean is64bit) {
        super(other.byteBuffer.duplicate().asReadOnlyBuffer(), is64bit);
        this.byteBuffer.order(other.byteBuffer.order());
        if (other instanceof RangeByteBufferReader) {
            RangeByteBufferReader o = (RangeByteBufferReader)other;
            this.virtualStart = o.virtualStart + offs;
            this.virtualLimit = this.virtualStart + size - 1;
            this.byteBuffer.position(this.virtualStart);
            if (this.virtualStart > o.virtualLimit || this.virtualLimit > o.virtualLimit) {
                throw new IllegalArgumentException();
            }
        } else {
            this.virtualStart = 0;
            this.virtualLimit = this.byteBuffer.limit();
        }
    }

    @Override
    public int size() {
        return this.virtualLimit - this.virtualStart + 1;
    }

    @Override
    public int position() {
        return this.byteBuffer.position() - this.virtualStart;
    }

    @Override
    public void setPosition(int position) {
        if ((position += this.virtualStart) > this.virtualLimit) {
            throw new IllegalArgumentException();
        }
        this.byteBuffer.position(position);
    }

    @Override
    protected int byteBufferDataStart() {
        return this.virtualStart;
    }

    @Override
    public void reset() {
        this.setPosition(this.virtualStart);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.byteBuffer.array(), this.virtualStart, this.size());
    }
}

