/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.macho.cmds;

import org.robovm.debugger.utils.bytebuffer.ByteBufferArrayReader;
import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;
import org.robovm.debugger.utils.macho.structs.Section;

public class SegmentCommand {
    private String segname;
    private long vmaddr;
    private long vmsize;
    private long fileoff;
    private long filesize;
    private int maxprot;
    private int initprot;
    private long nsects;
    private long flags;
    private int firstSectionIdx;
    private Section[] sections;
    private boolean is64b;

    public SegmentCommand(ByteBufferReader reader, boolean is64b, int firstSectionIdx) {
        if (is64b) {
            this.read64(reader, firstSectionIdx);
        } else {
            this.read32(reader, firstSectionIdx);
        }
    }

    public SegmentCommand read32(ByteBufferReader reader, int firstSectionIdx) {
        this.is64b = false;
        this.segname = reader.readString(16);
        this.vmaddr = reader.readUnsignedInt32();
        this.vmsize = reader.readUnsignedInt32();
        this.fileoff = reader.readUnsignedInt32();
        this.filesize = reader.readUnsignedInt32();
        this.maxprot = reader.readInt32();
        this.initprot = reader.readInt32();
        this.nsects = reader.readUnsignedInt32();
        this.flags = reader.readUnsignedInt32();
        this.readSections(reader);
        this.firstSectionIdx = firstSectionIdx;
        return this;
    }

    public SegmentCommand read64(ByteBufferReader reader, int firstSectionIdx) {
        this.is64b = true;
        this.segname = reader.readString(16);
        this.vmaddr = reader.readLong();
        this.vmsize = reader.readLong();
        this.fileoff = reader.readLong();
        this.filesize = reader.readLong();
        this.maxprot = reader.readInt32();
        this.initprot = reader.readInt32();
        this.nsects = reader.readUnsignedInt32();
        this.flags = reader.readUnsignedInt32();
        this.readSections(reader);
        this.firstSectionIdx = firstSectionIdx;
        return this;
    }

    private void readSections(ByteBufferReader reader) {
        this.sections = new Section[(int)this.nsects];
        if (this.nsects == 0L) {
            return;
        }
        ByteBufferReader sectReader = reader.slice((int)((long)Section.ITEM_SIZE(this.is64b()) * this.nsects));
        ByteBufferArrayReader<Section> arrayReader = new ByteBufferArrayReader<Section>(sectReader, Section.ITEM_SIZE(this.is64b), Section.OBJECT_READER(this.is64b), false);
        int idx = 0;
        for (Section sec : arrayReader) {
            this.sections[idx++] = sec;
        }
    }

    public String segname() {
        return this.segname;
    }

    public long vmaddr() {
        return this.vmaddr;
    }

    public long vmsize() {
        return this.vmsize;
    }

    public long fileoff() {
        return this.fileoff;
    }

    public long filesize() {
        return this.filesize;
    }

    public int maxprot() {
        return this.maxprot;
    }

    public int initprot() {
        return this.initprot;
    }

    public long nsects() {
        return this.nsects;
    }

    public long flags() {
        return this.flags;
    }

    public Section[] sections() {
        return this.sections;
    }

    public int firstSectionIdx() {
        return this.firstSectionIdx;
    }

    public boolean is64b() {
        return this.is64b;
    }
}

