/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.macho.structs;

import org.robovm.debugger.utils.bytebuffer.ByteBufferArrayReader;
import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;

public class FatArch {
    private int cputype;
    private int cpusubtype;
    private long offset;
    private long size;
    private long align;
    private long reserved;
    private boolean is64b;
    private static ByteBufferArrayReader.ObjectReader<FatArch> objectReader32 = new ByteBufferArrayReader.ObjectReader<FatArch>(){

        @Override
        public FatArch readObject(ByteBufferReader reader, FatArch object) {
            return object == null ? new FatArch(reader, false) : object.read32(reader);
        }
    };
    private static ByteBufferArrayReader.ObjectReader<FatArch> objectReader64 = new ByteBufferArrayReader.ObjectReader<FatArch>(){

        @Override
        public FatArch readObject(ByteBufferReader reader, FatArch object) {
            return object == null ? new FatArch(reader, true) : object.read64(reader);
        }
    };

    public FatArch(ByteBufferReader reader, boolean is64b) {
        if (is64b) {
            this.read64(reader);
        } else {
            this.read32(reader);
        }
    }

    public FatArch read32(ByteBufferReader reader) {
        this.cputype = reader.readInt32();
        this.cpusubtype = reader.readInt32();
        this.offset = reader.readUnsignedInt32();
        this.size = reader.readUnsignedInt32();
        this.align = reader.readUnsignedInt32();
        return this;
    }

    public FatArch read64(ByteBufferReader reader) {
        this.cputype = reader.readInt32();
        this.cpusubtype = reader.readInt32();
        this.offset = reader.readLong();
        this.size = reader.readLong();
        this.align = reader.readUnsignedInt32();
        this.reserved = reader.readUnsignedInt32();
        return this;
    }

    public int cputype() {
        return this.cputype;
    }

    public int cpusubtype() {
        return this.cpusubtype;
    }

    public long offset() {
        return this.offset;
    }

    public long size() {
        return this.size;
    }

    public long align() {
        return this.align;
    }

    public boolean is64b() {
        return this.is64b;
    }

    public static ByteBufferArrayReader.ObjectReader<FatArch> OBJECT_READER(boolean is64b) {
        return is64b ? objectReader64 : objectReader32;
    }

    public static int ITEM_SIZE(boolean is64b) {
        return is64b ? 32 : 20;
    }
}

