/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.gradle.tasks;

import java.io.File;
import org.gradle.api.GradleException;
import org.robovm.compiler.AppCompiler;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.target.ios.DeviceType;
import org.robovm.compiler.target.ios.IOSSimulatorLaunchParameters;
import org.robovm.gradle.tasks.AbstractRoboVMTask;

public abstract class AbstractSimulatorTask
extends AbstractRoboVMTask {
    protected void launch(DeviceType type) {
        try {
            File parent;
            boolean isWritable;
            AppCompiler compiler = this.build(this.getOs(), this.getArch(), this.getTargetType());
            if (this.extension.isSkipLaunch()) {
                return;
            }
            Config config = compiler.getConfig();
            IOSSimulatorLaunchParameters launchParameters = (IOSSimulatorLaunchParameters)config.getTarget().createLaunchParameters();
            launchParameters.setDeviceType(type);
            if (this.extension.getStdoutFifo() != null) {
                File stdoutFifo = new File(this.extension.getStdoutFifo());
                if (stdoutFifo.exists()) {
                    isWritable = stdoutFifo.isFile() && stdoutFifo.canWrite();
                } else {
                    parent = stdoutFifo.getParentFile();
                    boolean bl = isWritable = parent != null && parent.isDirectory() && parent.canWrite();
                }
                if (!isWritable) {
                    throw new GradleException("Unwritable 'stdoutFifo' specified for RoboVM compile: " + stdoutFifo);
                }
                launchParameters.setStdoutFifo(stdoutFifo);
            }
            if (this.extension.getStderrFifo() != null) {
                File stderrFifo = new File(this.extension.getStderrFifo());
                if (stderrFifo.exists()) {
                    isWritable = stderrFifo.isFile() && stderrFifo.canWrite();
                } else {
                    parent = stderrFifo.getParentFile();
                    boolean bl = isWritable = parent != null && parent.isDirectory() && parent.canWrite();
                }
                if (!isWritable) {
                    throw new GradleException("Unwritable 'stderrFifo' specified for RoboVM compile: " + stderrFifo);
                }
                launchParameters.setStderrFifo(stderrFifo);
            }
            compiler.launch(launchParameters);
        }
        catch (Throwable t) {
            throw new GradleException("Failed to launch simulator", t);
        }
    }

    protected abstract String getTargetType();

    protected abstract OS getOs();

    protected abstract Arch getArch();

    protected DeviceType getDeviceType(DeviceType.DeviceFamily family) {
        String deviceName = (String)this.project.getProperties().get("robovm.device.name");
        String sdkVersion = (String)this.project.getProperties().get("robovm.sdk.version");
        return DeviceType.getBestDeviceType(this.getArch(), family, deviceName, sdkVersion);
    }
}

