/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm;

import org.robovm.llvm.LlvmException;
import org.robovm.llvm.binding.ContextRef;
import org.robovm.llvm.binding.LLVM;

public class Context
implements AutoCloseable {
    private ContextRef ref;

    public Context() {
        this.ref = LLVM.ContextCreate();
        if (this.ref == null) {
            throw new LlvmException("Failed to create Context");
        }
    }

    private Context(ContextRef contextRef) {
        this.ref = contextRef;
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LlvmException("Already disposed");
        }
    }

    protected ContextRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    public synchronized void dispose() {
        LLVM.ContextDispose(this.getRef());
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public static Context getGlobalContext() {
        return new Context(LLVM.GetGlobalContext());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Context other = (Context)obj;
        return !(this.ref == null ? other.ref != null : !this.ref.equals(other.ref));
    }
}

