/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm;

import org.robovm.llvm.LlvmException;
import org.robovm.llvm.Type;
import org.robovm.llvm.binding.LLVM;
import org.robovm.llvm.binding.TargetDataRef;

public class DataLayout
implements AutoCloseable {
    protected TargetDataRef ref;

    DataLayout(TargetDataRef ref) {
        this.ref = ref;
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LlvmException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LLVM.DisposeTargetData(this.ref);
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public long getTypeAllocSize(Type type) {
        this.checkDisposed();
        return LLVM.ABISizeOfType(this.ref, type.ref).longValue();
    }

    public int getABITypeAlignment(Type type) {
        this.checkDisposed();
        return LLVM.ABIAlignmentOfType(this.ref, type.ref);
    }

    public long getTypeStoreSize(Type type) {
        this.checkDisposed();
        return LLVM.StoreSizeOfType(this.ref, type.ref).longValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataLayout other = (DataLayout)obj;
        return !(this.ref == null ? other.ref != null : !this.ref.equals(other.ref));
    }
}

