/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm.debuginfo;

public class DwarfDebugVariableInfo {
    public static final int OP_breg13 = 125;
    public static final int OP_fbreg = 145;
    public static final int OP_breg31 = 143;
    private final String name;
    private final boolean isArgument;
    private final int register;
    private final int offset;

    public DwarfDebugVariableInfo(String name, boolean isArgument, int register, int offset) {
        this.name = name;
        this.isArgument = isArgument;
        this.register = register;
        this.offset = offset;
    }

    public DwarfDebugVariableInfo(int register, int offset) {
        this.name = null;
        this.isArgument = false;
        this.register = register;
        this.offset = offset;
    }

    public String name() {
        return this.name;
    }

    public boolean isArgument() {
        return this.isArgument;
    }

    public int register() {
        return this.register;
    }

    public int offset() {
        return this.offset;
    }

    public static String registerName(int register) {
        if (register == 125) {
            return "OP_breg13";
        }
        if (register == 143) {
            return "OP_breg31";
        }
        if (register == 145) {
            return "OP_fbreg";
        }
        return "OP_" + Integer.toHexString(register);
    }

    public String toString() {
        return "DwarfDebugVariableInfo{name='" + this.name + '\'' + ", isArgument=" + this.isArgument + ", register=" + DwarfDebugVariableInfo.registerName(this.register) + ", offset=" + this.offset + '}';
    }
}

