/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import org.simpleframework.xml.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassTransform
implements Transform<Class> {
    ClassTransform() {
    }

    @Override
    public Class read(String target) throws Exception {
        Class type = this.readPrimitive(target);
        if (type == null) {
            ClassLoader loader = ClassTransform.getClassLoader();
            if (loader == null) {
                loader = this.getCallerClassLoader();
            }
            return loader.loadClass(target);
        }
        return type;
    }

    private Class readPrimitive(String target) throws Exception {
        if (target.equals("byte")) {
            return Byte.TYPE;
        }
        if (target.equals("short")) {
            return Short.TYPE;
        }
        if (target.equals("int")) {
            return Integer.TYPE;
        }
        if (target.equals("long")) {
            return Long.TYPE;
        }
        if (target.equals("char")) {
            return Character.TYPE;
        }
        if (target.equals("float")) {
            return Float.TYPE;
        }
        if (target.equals("double")) {
            return Double.TYPE;
        }
        if (target.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (target.equals("void")) {
            return Void.TYPE;
        }
        return null;
    }

    @Override
    public String write(Class target) throws Exception {
        return target.getName();
    }

    private ClassLoader getCallerClassLoader() {
        return this.getClass().getClassLoader();
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

