/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.RefType;
import soot.SootMethodType;
import soot.Type;
import soot.jimple.Constant;
import soot.jimple.ConstantSwitch;
import soot.util.Switch;

class JMethodType
extends Constant
implements SootMethodType {
    private static final long serialVersionUID = 1L;
    private final Type returnType;
    private final List<Type> parameterTypes;

    public JMethodType(Type returnType, List<Type> parameterTypes) {
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public List<Type> getParameterTypes() {
        return Collections.unmodifiableList(this.parameterTypes);
    }

    @Override
    public Type getType() {
        return RefType.v("java.lang.invoke.MethodType");
    }

    @Override
    public void apply(Switch sw) {
        ((ConstantSwitch)sw).defaultCase(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        Iterator<Type> it = this.parameterTypes.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.append(')').append(this.returnType).toString();
    }
}

