/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import soot.SootMethodRef;
import soot.UnitPrinter;
import soot.ValueBox;
import soot.jimple.ExprSwitch;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.util.Switch;

public abstract class AbstractSpecialInvokeExpr
extends AbstractInstanceInvokeExpr
implements SpecialInvokeExpr {
    protected AbstractSpecialInvokeExpr(ValueBox baseBox, SootMethodRef methodRef, ValueBox[] argBoxes) {
        if (methodRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.baseBox = baseBox;
        this.methodRef = methodRef;
        this.argBoxes = argBoxes;
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractSpecialInvokeExpr) {
            AbstractSpecialInvokeExpr ie = (AbstractSpecialInvokeExpr)o;
            if (!this.baseBox.getValue().equivTo(ie.baseBox.getValue()) || !this.getMethod().equals(ie.getMethod()) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            for (ValueBox element : this.argBoxes) {
                if (element.getValue().equivTo(element.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.baseBox.getValue().equivHashCode() * 101 + this.getMethod().equivHashCode() * 17;
    }

    @Override
    public abstract Object clone();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("specialinvoke " + this.baseBox.getValue().toString() + "." + this.methodRef.getSignature() + "(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("specialinvoke");
        up.literal(" ");
        this.baseBox.toString(up);
        up.literal(".");
        up.methodRef(this.methodRef);
        up.literal("(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
        }
        up.literal(")");
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseSpecialInvokeExpr(this);
    }
}

