/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import soot.toolkits.graph.DirectedGraph;

public class StronglyConnectedComponentsFast<N> {
    protected final List<List<N>> componentList = new ArrayList<List<N>>();
    protected final List<List<N>> trueComponentList = new ArrayList<List<N>>();
    protected int index = 0;
    protected Map<N, Integer> indexForNode;
    protected Map<N, Integer> lowlinkForNode;
    protected Stack<N> s;
    protected DirectedGraph<N> g;

    public StronglyConnectedComponentsFast(DirectedGraph<N> g) {
        this.g = g;
        this.s = new Stack();
        List<N> heads = g.getHeads();
        if (heads.size() > 1) {
            throw new RuntimeException("Cannot compute SCCs for graph with number of heads = " + heads.size());
        }
        this.indexForNode = new HashMap<N, Integer>();
        this.lowlinkForNode = new HashMap<N, Integer>();
        this.recurse(heads.get(0));
        this.indexForNode = null;
        this.lowlinkForNode = null;
        this.s = null;
        g = null;
    }

    protected void recurse(N v) {
        this.indexForNode.put(v, this.index);
        this.lowlinkForNode.put(v, this.index);
        ++this.index;
        this.s.push(v);
        for (N succ : this.g.getSuccsOf(v)) {
            if (!this.indexForNode.containsKey(succ)) {
                this.recurse(succ);
                this.lowlinkForNode.put(v, Math.min(this.lowlinkForNode.get(v), this.lowlinkForNode.get(succ)));
                continue;
            }
            if (!this.s.contains(succ)) continue;
            this.lowlinkForNode.put(v, Math.min(this.lowlinkForNode.get(v), this.indexForNode.get(succ)));
        }
        if (this.lowlinkForNode.get(v).intValue() == this.indexForNode.get(v).intValue()) {
            N v2;
            ArrayList<N> scc = new ArrayList<N>();
            do {
                v2 = this.s.pop();
                scc.add(v2);
            } while (v != v2);
            this.componentList.add(scc);
            if (scc.size() > 1) {
                this.trueComponentList.add(scc);
            } else {
                Object n = scc.get(0);
                if (this.g.getSuccsOf(n).contains(n)) {
                    this.trueComponentList.add(scc);
                }
            }
        }
    }

    public List<List<N>> getComponents() {
        return this.componentList;
    }

    public List<List<N>> getTrueComponents() {
        return this.trueComponentList;
    }
}

