/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.LocalVariable;
import soot.PatchingChain;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.toolkits.scalar.UnitValueBoxPair;

public class LocalSplitter
extends BodyTransformer {
    public LocalSplitter(Singletons.Global g) {
    }

    public static LocalSplitter v() {
        return G.v().soot_toolkits_scalar_LocalSplitter();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map options) {
        PatchingChain<Unit> units = body.getUnits();
        List<List> webs = new ArrayList<List>();
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Splitting locals...");
        }
        HashMap boxToSet = new HashMap(units.size() * 2 + 1, 0.7f);
        if (Options.v().time()) {
            Timers.v().splitPhase1Timer.start();
        }
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body);
        SmartLocalDefs localDefs = new SmartLocalDefs(graph, new SimpleLiveLocals(graph));
        SimpleLocalUses localUses = new SimpleLocalUses(graph, (LocalDefs)localDefs);
        if (Options.v().time()) {
            Timers.v().splitPhase1Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().splitPhase2Timer.start();
        }
        HashSet<ValueBox> markedBoxes = new HashSet<ValueBox>();
        HashMap<ValueBox, Unit> boxToUnit = new HashMap<ValueBox, Unit>(units.size() * 2 + 1, 0.7f);
        for (Unit s : units) {
            ValueBox loBox;
            Value lo;
            if (s.getDefBoxes().size() > 1) {
                throw new RuntimeException("stmt with more than 1 defbox!");
            }
            if (s.getDefBoxes().size() < 1 || !((lo = (loBox = s.getDefBoxes().get(0)).getValue()) instanceof Local) || markedBoxes.contains(loBox)) continue;
            LinkedList<Unit> defsToVisit = new LinkedList<Unit>();
            LinkedList<ValueBox> boxesToVisit = new LinkedList<ValueBox>();
            ArrayList<ValueBox> web = new ArrayList<ValueBox>();
            webs.add(web);
            defsToVisit.add(s);
            markedBoxes.add(loBox);
            boxToUnit.put(loBox, s);
            while (!boxesToVisit.isEmpty() || !defsToVisit.isEmpty()) {
                if (!defsToVisit.isEmpty()) {
                    Unit d = (Unit)defsToVisit.removeFirst();
                    web.add(d.getDefBoxes().get(0));
                    List uses = localUses.getUsesOf(d);
                    for (UnitValueBoxPair use : uses) {
                        if (markedBoxes.contains(use.valueBox)) continue;
                        markedBoxes.add(use.valueBox);
                        boxesToVisit.addLast(use.valueBox);
                        boxToUnit.put(use.valueBox, use.unit);
                    }
                    continue;
                }
                ValueBox box = (ValueBox)boxesToVisit.removeFirst();
                web.add(box);
                List<Unit> defs = localDefs.getDefsOfAt((Local)box.getValue(), (Unit)boxToUnit.get(box));
                for (Unit u : defs) {
                    for (ValueBox b : u.getDefBoxes()) {
                        if (markedBoxes.contains(b)) continue;
                        markedBoxes.add(b);
                        defsToVisit.addLast(u);
                        boxToUnit.put(b, u);
                    }
                }
            }
        }
        webs = this.mergeWebs(body, webs, boxToUnit, localUses);
        HashMap<Local, Integer> localToUseCount = new HashMap<Local, Integer>(body.getLocalCount() * 2 + 1, 0.7f);
        for (List web : webs) {
            ValueBox rep = (ValueBox)web.get(0);
            Local desiredLocal = (Local)rep.getValue();
            if (!localToUseCount.containsKey(desiredLocal)) {
                localToUseCount.put(desiredLocal, new Integer(1));
                continue;
            }
            int useCount = (Integer)localToUseCount.get(desiredLocal) + 1;
            localToUseCount.put(desiredLocal, new Integer(useCount));
            Local local = (Local)desiredLocal.clone();
            local.setName(desiredLocal.getName() + "#" + useCount);
            body.getLocals().add(local);
            for (ValueBox box : web) {
                box.setValue(local);
            }
        }
        if (Options.v().time()) {
            Timers.v().splitPhase2Timer.end();
        }
    }

    private List<List> mergeWebs(Body body, List<List> webs, Map<ValueBox, Unit> boxToUnit, LocalUses localUses) {
        ArrayList<List> result = new ArrayList<List>();
        LinkedList<List> websCopy = new LinkedList<List>(webs);
        while (!websCopy.isEmpty()) {
            List web1 = websCopy.removeFirst();
            Local local1 = (Local)((ValueBox)web1.get(0)).getValue();
            if (local1.getIndex() == -1) {
                result.add(web1);
                continue;
            }
            ArrayList mergedWeb = new ArrayList(web1);
            Set<LocalVariable> lvs1 = this.findLocalVariables(web1, local1, null, boxToUnit, body);
            String expectedType = lvs1.isEmpty() ? null : lvs1.iterator().next().getDescriptor();
            Iterator it2 = websCopy.iterator();
            while (it2.hasNext()) {
                List web2 = (List)it2.next();
                Local local2 = (Local)((ValueBox)web2.get(0)).getValue();
                if (!local1.equals(local2)) continue;
                Set<LocalVariable> lvs2 = this.findLocalVariables(web2, local2, expectedType, boxToUnit, body);
                if (lvs1.isEmpty() || !lvs1.equals(lvs2)) continue;
                mergedWeb.addAll(web2);
                it2.remove();
            }
            result.add(mergedWeb);
        }
        return result;
    }

    private Set<LocalVariable> findLocalVariables(List<ValueBox> web, Local local, String expectedTypeDescriptor, Map<ValueBox, Unit> boxToUnit, Body body) {
        HashSet<LocalVariable> lvs = new HashSet<LocalVariable>();
        if (local.getIndex() != -1) {
            boolean incompatibleType = false;
            String firstType = null;
            for (ValueBox box : web) {
                LocalVariable lv = this.findLocalVariable(body, local.getIndex(), boxToUnit.get(box));
                if (lv == null) continue;
                lvs.add(lv);
                if (expectedTypeDescriptor != null && lv.getDescriptor().equals(expectedTypeDescriptor)) {
                    incompatibleType = true;
                }
                if (firstType == null) {
                    firstType = lv.getDescriptor();
                    continue;
                }
                if (firstType.equals(lv.getDescriptor())) continue;
                incompatibleType = true;
            }
            if (incompatibleType) {
                lvs.clear();
                return lvs;
            }
            if (lvs.size() > 1) {
                String name = null;
                for (LocalVariable lv : lvs) {
                    if (name == null) {
                        name = lv.getName();
                        continue;
                    }
                    if (lv.getName().equals(name)) continue;
                    throw new IllegalStateException("Found LocalVariables do not refer to a variable with the same name: " + lvs);
                }
            }
        }
        return lvs;
    }

    private LocalVariable findLocalVariable(Body body, int index, Unit unit) {
        PatchingChain<Unit> units = body.getUnits();
        for (LocalVariable lv : body.getLocalVariables()) {
            if (lv.getIndex() != index || unit != lv.getStartUnit() && !units.follows(unit, lv.getStartUnit()) || lv.getEndUnit() != null && !units.follows(lv.getEndUnit(), unit)) continue;
            return lv;
        }
        return null;
    }
}

