/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.NoSuchElementException;

public class Heap {
    final Keys keys;
    final ArrayList<Object> list = new ArrayList();
    final HashSet<Object> contents = new HashSet();
    private int size;

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public Heap(Keys keys) {
        this.keys = keys;
        this.list.add(null);
        this.list.add(null);
    }

    public boolean contains(Object o) {
        return this.contents.contains(o);
    }

    public boolean add(Object o) {
        if (!this.contents.add(o)) {
            return false;
        }
        this.insert(o);
        return true;
    }

    private void insert(Object o) {
        ++this.size;
        int i = this.size;
        while (this.list.size() <= this.size) {
            this.list.add(null);
        }
        while (i > 1 && this.key(this.parent(i)) > this.key(o)) {
            this.list.set(i, this.list.get(this.parent(i)));
            i = this.parent(i);
        }
        this.list.set(i, o);
    }

    private int left(int i) {
        return 2 * i;
    }

    private int right(int i) {
        return 2 * i + 1;
    }

    private int parent(int i) {
        return i / 2;
    }

    private void heapify(int i) {
        int l = this.left(i);
        int r = this.right(i);
        int largest = l <= this.size && this.key(l) < this.key(i) ? l : i;
        if (r <= this.size && this.key(r) < this.key(largest)) {
            largest = r;
        }
        if (largest != i) {
            Object iEdge = this.list.get(i);
            Object largestEdge = this.list.get(largest);
            this.list.set(i, largestEdge);
            this.list.set(largest, iEdge);
            this.heapify(largest);
        }
    }

    public Object min() {
        return this.list.get(1);
    }

    public Object removeMin() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Object ret = this.list.get(1);
        this.contents.remove(ret);
        this.list.set(1, this.list.get(this.size));
        this.list.set(this.size, null);
        --this.size;
        this.heapify(1);
        return ret;
    }

    public void heapify() {
        for (int i = this.size; i > 0; --i) {
            this.heapify(i);
        }
    }

    private int key(Object o) {
        return this.keys.key(o);
    }

    private int key(int i) {
        return this.keys.key(this.list.get(i));
    }

    public static interface Keys {
        public int key(Object var1);
    }
}

