/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Iterator;
import soot.util.ArrayNumberer;
import soot.util.Numberable;

public final class SmallNumberedMap {
    private Numberable[] array = new Numberable[8];
    private Object[] values = new Object[8];
    private int size = 0;
    private ArrayNumberer universe;

    public SmallNumberedMap(ArrayNumberer universe) {
        this.universe = universe;
    }

    public boolean put(Numberable key, Object value) {
        int pos = this.findPosition(key);
        if (this.array[pos] == key) {
            if (this.values[pos] == value) {
                return false;
            }
            this.values[pos] = value;
            return true;
        }
        ++this.size;
        if (this.size * 3 > this.array.length * 2) {
            this.doubleSize();
            pos = this.findPosition(key);
        }
        this.array[pos] = key;
        this.values[pos] = value;
        return true;
    }

    public Object get(Numberable key) {
        return this.values[this.findPosition(key)];
    }

    public int nonNullSize() {
        int ret = 0;
        for (Object element : this.values) {
            if (element == null) continue;
            ++ret;
        }
        return ret;
    }

    public Iterator keyIterator() {
        return new KeyIterator(this);
    }

    public Iterator iterator() {
        return new ValueIterator(this);
    }

    private final int findPosition(Numberable o) {
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        number &= this.array.length - 1;
        while (this.array[number] != o) {
            if (this.array[number] == null) {
                return number;
            }
            number = number + 1 & this.array.length - 1;
        }
        return number;
    }

    private final void doubleSize() {
        int uniSize = this.universe.size();
        if (this.array.length * 128 > uniSize) {
            // empty if block
        }
        Numberable[] oldArray = this.array;
        Object[] oldValues = this.values;
        int newLength = this.array.length * 2;
        this.values = new Object[newLength];
        this.array = new Numberable[newLength];
        for (int i = 0; i < oldArray.length; ++i) {
            Numberable element = oldArray[i];
            if (element == null) continue;
            int pos = this.findPosition(element);
            this.array[pos] = element;
            this.values[pos] = oldValues[i];
        }
    }

    class ValueIterator
    extends SmallNumberedMapIterator {
        ValueIterator(SmallNumberedMap map) {
            super(map);
        }

        @Override
        public final Object next() {
            Object ret = SmallNumberedMap.this.values[this.cur];
            ++this.cur;
            this.seekNext();
            return ret;
        }
    }

    class KeyIterator
    extends SmallNumberedMapIterator {
        KeyIterator(SmallNumberedMap map) {
            super(map);
        }

        @Override
        public final Object next() {
            Numberable ret = SmallNumberedMap.this.array[this.cur];
            ++this.cur;
            this.seekNext();
            return ret;
        }
    }

    abstract class SmallNumberedMapIterator
    implements Iterator {
        SmallNumberedMap map;
        int cur = 0;

        SmallNumberedMapIterator(SmallNumberedMap map) {
            this.map = map;
            this.seekNext();
        }

        protected final void seekNext() {
            try {
                while (this.map.values[this.cur] == null) {
                    ++this.cur;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.cur = -1;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.cur != -1;
        }

        public abstract Object next();

        @Override
        public void remove() {
            throw new RuntimeException("Not implemented.");
        }
    }
}

