/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NativeLibrary {
    private static boolean loaded = false;
    public static final boolean supportedPlatform;
    private static final String os;
    private static final String arch;
    private static final String libName;

    public static synchronized void load() {
        if (loaded) {
            return;
        }
        if (!supportedPlatform) {
            return;
        }
        String prefix = libName.substring(0, libName.lastIndexOf(46));
        String ext = libName.substring(libName.lastIndexOf(46));
        InputStream in = NativeLibrary.class.getResourceAsStream("binding/" + os + "/" + arch + "/" + libName);
        if (in == null) {
            throw new UnsatisfiedLinkError("Native library for " + os + "-" + arch + " not found");
        }
        BufferedOutputStream out = null;
        File tmpLibFile = null;
        try {
            tmpLibFile = File.createTempFile(prefix, ext);
            tmpLibFile.deleteOnExit();
            out = new BufferedOutputStream(new FileOutputStream(tmpLibFile));
            NativeLibrary.copy(in, out);
        }
        catch (IOException e) {
            try {
                throw (Error)new UnsatisfiedLinkError(e.getMessage()).initCause(e);
            }
            catch (Throwable throwable) {
                NativeLibrary.closeQuietly(in);
                NativeLibrary.closeQuietly(out);
                throw throwable;
            }
        }
        NativeLibrary.closeQuietly(in);
        NativeLibrary.closeQuietly(out);
        Runtime.getRuntime().load(tmpLibFile.getAbsolutePath());
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
    }

    private static void closeQuietly(Closeable in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        String osProp = System.getProperty("os.name").toLowerCase();
        String archProp = System.getProperty("os.arch").toLowerCase();
        String ext = null;
        if (osProp.startsWith("mac") || osProp.startsWith("darwin")) {
            os = "macosx";
            ext = ".dylib";
        } else {
            os = null;
        }
        arch = archProp.matches("amd64|x86[-_]64") ? "x86_64" : (archProp.matches("aarch64|arm64") ? "arm64" : null);
        supportedPlatform = os != null && arch != null;
        libName = supportedPlatform ? "librobovm-libimobiledevice" + ext : null;
    }
}

